/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json.impl;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.List;
import java.util.Map;

public final class JsonUtil {
    public static final Base64.Encoder BASE64_ENCODER;
    public static final Base64.Decoder BASE64_DECODER;

    public static Object wrapJsonValue(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Map) {
            val = new JsonObject((Map)val);
        } else if (val instanceof List) {
            val = new JsonArray((List)val);
        } else if (val instanceof Instant) {
            val = DateTimeFormatter.ISO_INSTANT.format((Instant)val);
        } else if (val instanceof byte[]) {
            val = BASE64_ENCODER.encodeToString((byte[])val);
        } else if (val instanceof Enum) {
            val = ((Enum)val).name();
        }
        return val;
    }

    public static Object checkAndCopy(Object val) {
        if (!(val == null || val instanceof Number && !(val instanceof BigDecimal) || val instanceof Boolean || val instanceof String || val instanceof Character)) {
            if (val instanceof CharSequence) {
                val = val.toString();
            } else if (val instanceof JsonObject) {
                val = ((JsonObject)val).copy();
            } else if (val instanceof JsonArray) {
                val = ((JsonArray)val).copy();
            } else if (val instanceof Map) {
                val = new JsonObject((Map)val).copy();
            } else if (val instanceof List) {
                val = new JsonArray((List)val).copy();
            } else if (!(val instanceof byte[] || val instanceof Instant || val instanceof Enum)) {
                throw new IllegalStateException("Illegal type in Json: " + val.getClass());
            }
        }
        return val;
    }

    static {
        if ("legacy".equalsIgnoreCase(System.getProperty("vertx.json.base64"))) {
            BASE64_ENCODER = Base64.getEncoder();
            BASE64_DECODER = Base64.getDecoder();
        } else {
            BASE64_ENCODER = Base64.getUrlEncoder().withoutPadding();
            BASE64_DECODER = Base64.getUrlDecoder();
        }
    }
}

