/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.impl.PromiseInternal;
import java.util.ArrayList;
import java.util.Objects;

class FutureImpl<T>
implements PromiseInternal<T>,
Future<T> {
    private final ContextInternal context;
    private boolean failed;
    private boolean succeeded;
    private Handler<AsyncResult<T>> handler;
    private T result;
    private Throwable throwable;

    FutureImpl() {
        this(null);
    }

    FutureImpl(ContextInternal context) {
        this.context = context;
    }

    @Override
    public ContextInternal context() {
        return this.context;
    }

    @Override
    public synchronized T result() {
        return this.result;
    }

    @Override
    public synchronized Throwable cause() {
        return this.throwable;
    }

    @Override
    public synchronized boolean succeeded() {
        return this.succeeded;
    }

    @Override
    public synchronized boolean failed() {
        return this.failed;
    }

    @Override
    public synchronized boolean isComplete() {
        return this.failed || this.succeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<T> onComplete(Handler<AsyncResult<T>> h) {
        Objects.requireNonNull(h, "No null handler accepted");
        FutureImpl futureImpl = this;
        synchronized (futureImpl) {
            if (!this.isComplete()) {
                if (this.handler == null) {
                    this.handler = h;
                } else {
                    this.addHandler(h);
                }
                return this;
            }
        }
        this.dispatch(h);
        return this;
    }

    private void addHandler(Handler<AsyncResult<T>> h) {
        Handlers handlers;
        if (this.handler instanceof Handlers) {
            handlers = (Handlers)this.handler;
        } else {
            handlers = new Handlers();
            handlers.add(this.handler);
            this.handler = handlers;
        }
        handlers.add(h);
    }

    protected void dispatch(Handler<AsyncResult<T>> handler) {
        if (handler instanceof Handlers) {
            for (Handler h : (Handlers)handler) {
                this.doDispatch(h);
            }
        } else {
            this.doDispatch(handler);
        }
    }

    private void doDispatch(Handler<AsyncResult<T>> handler) {
        if (this.context != null) {
            this.context.dispatch(this, handler);
        } else {
            handler.handle(this);
        }
    }

    @Override
    public synchronized Handler<AsyncResult<T>> getHandler() {
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryComplete(T result) {
        Handler<AsyncResult<T>> h;
        FutureImpl futureImpl = this;
        synchronized (futureImpl) {
            if (this.succeeded || this.failed) {
                return false;
            }
            this.result = result;
            this.succeeded = true;
            h = this.handler;
            this.handler = null;
        }
        if (h != null) {
            this.dispatch(h);
        }
        return true;
    }

    @Override
    public void handle(Future<T> ar) {
        if (ar.succeeded()) {
            this.complete(ar.result());
        } else {
            this.fail(ar.cause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryFail(Throwable cause) {
        Handler<AsyncResult<T>> h;
        FutureImpl futureImpl = this;
        synchronized (futureImpl) {
            if (this.succeeded || this.failed) {
                return false;
            }
            this.throwable = cause != null ? cause : new NoStackTraceThrowable(null);
            this.failed = true;
            h = this.handler;
            this.handler = null;
        }
        if (h != null) {
            this.dispatch(h);
        }
        return true;
    }

    @Override
    public Future<T> future() {
        return this;
    }

    public void operationComplete(io.netty.util.concurrent.Future<T> future) {
        if (future.isSuccess()) {
            this.complete(future.getNow());
        } else {
            this.fail(future.cause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        FutureImpl futureImpl = this;
        synchronized (futureImpl) {
            if (this.succeeded) {
                return "Future{result=" + this.result + "}";
            }
            if (this.failed) {
                return "Future{cause=" + this.throwable.getMessage() + "}";
            }
            return "Future{unresolved}";
        }
    }

    private class Handlers<T>
    extends ArrayList<Handler<AsyncResult<T>>>
    implements Handler<AsyncResult<T>> {
        private Handlers() {
        }

        @Override
        public void handle(AsyncResult<T> res) {
            for (Handler handler : this) {
                handler.handle(res);
            }
        }
    }
}

