/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Starter;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.BlockedThreadChecker;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.PromiseInternal;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.impl.launcher.VertxCommandLauncher;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

abstract class AbstractContext
implements ContextInternal {
    static final String THREAD_CHECKS_PROP_NAME = "vertx.threadChecks";
    static final boolean THREAD_CHECKS = Boolean.getBoolean("vertx.threadChecks");
    private static FastThreadLocal<Holder> holderLocal = new FastThreadLocal<Holder>(){

        protected Holder initialValue() {
            return new Holder();
        }
    };

    AbstractContext() {
    }

    static Context context() {
        Thread current = Thread.currentThread();
        if (current instanceof VertxThread) {
            return ((VertxThread)((Object)current)).context();
        }
        if (current instanceof FastThreadLocalThread) {
            return ((Holder)AbstractContext.holderLocal.get()).ctx;
        }
        return null;
    }

    abstract <T> void execute(T var1, Handler<T> var2);

    @Override
    public abstract boolean isEventLoopContext();

    @Override
    public boolean isWorkerContext() {
        return !this.isEventLoopContext();
    }

    @Override
    public final void dispatchFromIO(Handler<Void> handler) {
        this.dispatchFromIO(null, handler);
    }

    @Override
    public final void schedule(Handler<Void> task) {
        this.schedule(null, task);
    }

    @Override
    public final void emit(Handler<Void> handler) {
        this.emit((T)null, (Handler)handler);
    }

    @Override
    public final ContextInternal beginEmission() {
        Thread th = Thread.currentThread();
        ContextInternal prev = th instanceof VertxThread ? ((VertxThread)((Object)th)).beginEmission(this) : this.beginNettyThreadEmit(th);
        if (!VertxThread.DISABLE_TCCL) {
            th.setContextClassLoader(this.classLoader());
        }
        return prev;
    }

    private ContextInternal beginNettyThreadEmit(Thread th) {
        if (th instanceof FastThreadLocalThread) {
            Holder holder = (Holder)holderLocal.get();
            ContextInternal prev = holder.ctx;
            if (!ContextImpl.DISABLE_TIMINGS) {
                if (holder.checker == null) {
                    BlockedThreadChecker checker;
                    holder.checker = checker = this.owner().blockedThreadChecker();
                    holder.maxExecTime = this.owner().maxEventLoopExecTime();
                    holder.maxExecTimeUnit = this.owner().maxEventLoopExecTimeUnit();
                    checker.registerThread(th, holder);
                }
                if (holder.ctx == null) {
                    holder.startTime = System.nanoTime();
                }
            }
            holder.ctx = this;
            return prev;
        }
        throw new IllegalStateException("Uh oh! context executing with wrong thread! " + th);
    }

    @Override
    public final void endEmission(ContextInternal previous) {
        Thread th = Thread.currentThread();
        if (!VertxThread.DISABLE_TCCL) {
            th.setContextClassLoader(previous != null ? previous.classLoader() : null);
        }
        if (th instanceof VertxThread) {
            ((VertxThread)((Object)th)).endEmission(previous);
        } else {
            this.endNettyThreadAssociation(th, previous);
        }
    }

    private void endNettyThreadAssociation(Thread th, ContextInternal prev) {
        if (th instanceof FastThreadLocalThread) {
            Holder holder = (Holder)holderLocal.get();
            holder.ctx = prev;
            if (!ContextImpl.DISABLE_TIMINGS && holder.ctx == null) {
                holder.startTime = 0L;
            }
        } else {
            throw new IllegalStateException("Uh oh! context executing with wrong thread! " + th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void emit(T event, Handler<T> handler) {
        ContextInternal prev = this.beginEmission();
        try {
            handler.handle(event);
        }
        catch (Throwable t) {
            this.reportException(t);
        }
        finally {
            this.endEmission(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void emit(Runnable handler) {
        ContextInternal prev = this.beginEmission();
        try {
            handler.run();
        }
        catch (Throwable t) {
            this.reportException(t);
        }
        finally {
            this.endEmission(prev);
        }
    }

    static void checkEventLoopThread() {
        Thread current = Thread.currentThread();
        if (!(current instanceof FastThreadLocalThread)) {
            throw new IllegalStateException("Expected to be on Vert.x thread, but actually on: " + current);
        }
        if (current instanceof VertxThread && ((VertxThread)((Object)current)).isWorker()) {
            throw new IllegalStateException("Event delivered on unexpected worker thread " + current);
        }
    }

    @Override
    public final void runOnContext(Handler<Void> handler) {
        try {
            this.execute(null, handler);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public final List<String> processArgs() {
        List<String> processArgument = VertxCommandLauncher.getProcessArguments();
        return processArgument != null ? processArgument : Starter.PROCESS_ARGS;
    }

    @Override
    public final <T> void executeBlockingInternal(Handler<Promise<T>> action, Handler<AsyncResult<T>> resultHandler) {
        Future<T> fut = this.executeBlockingInternal(action);
        AbstractContext.setResultHandler(this, fut, resultHandler);
    }

    @Override
    public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> resultHandler) {
        Future<T> fut = this.executeBlocking(blockingCodeHandler, ordered);
        AbstractContext.setResultHandler(this, fut, resultHandler);
    }

    @Override
    public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, TaskQueue queue, Handler<AsyncResult<T>> resultHandler) {
        Future<T> fut = this.executeBlocking(blockingCodeHandler, queue);
        AbstractContext.setResultHandler(this, fut, resultHandler);
    }

    @Override
    public final <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler) {
        this.executeBlocking(blockingCodeHandler, true, resultHandler);
    }

    @Override
    public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler) {
        return this.executeBlocking(blockingCodeHandler, true);
    }

    @Override
    public <T> PromiseInternal<T> promise() {
        return Future.factory.promise(this);
    }

    @Override
    public <T> PromiseInternal<T> promise(Handler<AsyncResult<T>> handler) {
        if (handler instanceof PromiseInternal) {
            return (PromiseInternal)handler;
        }
        PromiseInternal<T> promise = this.promise();
        promise.future().setHandler(handler);
        return promise;
    }

    @Override
    public <T> Future<T> succeededFuture() {
        return Future.factory.succeededFuture(this);
    }

    @Override
    public <T> Future<T> succeededFuture(T result) {
        return Future.factory.succeededFuture(this, result);
    }

    @Override
    public <T> Future<T> failedFuture(Throwable failure) {
        return Future.factory.failedFuture((ContextInternal)this, failure);
    }

    @Override
    public <T> Future<T> failedFuture(String message) {
        return Future.factory.failedFuture((ContextInternal)this, message);
    }

    @Override
    public final ContextInternal duplicate() {
        return this.duplicate(null);
    }

    @Override
    public final <T> T get(String key) {
        return (T)this.contextData().get(key);
    }

    @Override
    public final void put(String key, Object value) {
        this.contextData().put(key, value);
    }

    @Override
    public final boolean remove(String key) {
        return this.contextData().remove(key) != null;
    }

    @Override
    public final <T> T getLocal(String key) {
        return (T)this.localContextData().get(key);
    }

    @Override
    public final void putLocal(String key, Object value) {
        this.localContextData().put(key, value);
    }

    @Override
    public final boolean removeLocal(String key) {
        return this.localContextData().remove(key) != null;
    }

    static <T> void setResultHandler(ContextInternal ctx, Future<T> fut, Handler<AsyncResult<T>> resultHandler) {
        if (resultHandler != null) {
            fut.setHandler(resultHandler);
        } else {
            fut.setHandler(ar -> {
                if (ar.failed()) {
                    ctx.reportException(ar.cause());
                }
            });
        }
    }

    static class Holder
    implements BlockedThreadChecker.Task {
        BlockedThreadChecker checker;
        ContextInternal ctx;
        long startTime = 0L;
        long maxExecTime = VertxOptions.DEFAULT_MAX_EVENT_LOOP_EXECUTE_TIME;
        TimeUnit maxExecTimeUnit = VertxOptions.DEFAULT_MAX_EVENT_LOOP_EXECUTE_TIME_UNIT;

        Holder() {
        }

        @Override
        public long startTime() {
            return this.startTime;
        }

        @Override
        public long maxExecTime() {
            return this.maxExecTime;
        }

        @Override
        public TimeUnit maxExecTimeUnit() {
            return this.maxExecTimeUnit;
        }
    }
}

