/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.DeliveryContext;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.impl.EventBusImpl;
import io.vertx.core.eventbus.impl.HandlerHolder;
import io.vertx.core.eventbus.impl.MessageImpl;
import io.vertx.core.eventbus.impl.MessageTagExtractor;
import io.vertx.core.eventbus.impl.clustered.ClusteredMessage;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import java.util.Iterator;

abstract class HandlerRegistration<T> {
    private static final Logger log = LoggerFactory.getLogger(HandlerRegistration.class);
    public final ContextInternal context;
    public final EventBusImpl bus;
    public final String address;
    public final boolean src;
    private HandlerHolder<T> registered;
    private Object metric;

    HandlerRegistration(ContextInternal context, EventBusImpl bus, String address, boolean src) {
        this.context = context;
        this.bus = bus;
        this.src = src;
        this.address = address;
    }

    final void receive(MessageImpl<?, T> msg) {
        if (this.bus.metrics != null) {
            this.bus.metrics.scheduleMessage(this.metric, msg.isLocal());
        }
        this.doReceive(msg);
    }

    protected abstract void doReceive(Message<T> var1);

    protected abstract void doUnregister();

    synchronized void register(String repliedAddress, boolean localOnly, Handler<AsyncResult<Void>> promise) {
        if (this.registered != null) {
            throw new IllegalStateException();
        }
        this.registered = this.bus.addRegistration(this.address, this, repliedAddress != null, localOnly, promise);
        if (this.bus.metrics != null) {
            this.metric = this.bus.metrics.handlerRegistered(this.address, repliedAddress);
        }
    }

    public synchronized boolean isRegistered() {
        return this.registered != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> unregister() {
        PromiseInternal<Void> promise = this.context.promise();
        HandlerRegistration handlerRegistration = this;
        synchronized (handlerRegistration) {
            if (this.registered != null) {
                this.bus.removeRegistration(this.registered, promise);
                this.registered = null;
                if (this.bus.metrics != null) {
                    this.bus.metrics.handlerUnregistered(this.metric);
                    this.metric = null;
                }
            } else {
                promise.complete();
            }
        }
        this.doUnregister();
        return promise.future();
    }

    public void unregister(Handler<AsyncResult<Void>> completionHandler) {
        Future<Void> fut = this.unregister();
        if (completionHandler != null) {
            fut.setHandler(completionHandler);
        }
    }

    void dispatch(Handler<Message<T>> theHandler, Message<T> message, ContextInternal context) {
        InboundDeliveryContext deliveryCtx = new InboundDeliveryContext((MessageImpl)message, theHandler, context);
        deliveryCtx.dispatch();
    }

    private class InboundDeliveryContext
    implements DeliveryContext<T> {
        private final MessageImpl<?, T> message;
        private final Iterator<Handler<DeliveryContext>> iter;
        private final Handler<Message<T>> handler;
        private final ContextInternal context;

        private InboundDeliveryContext(MessageImpl<?, T> message, Handler<Message<T>> handler, ContextInternal context) {
            this.message = message;
            this.handler = handler;
            this.iter = message.bus.receiveInterceptors();
            this.context = context;
        }

        void dispatch() {
            this.context.emit(v -> this.next());
        }

        @Override
        public Message<T> message() {
            return this.message;
        }

        @Override
        public void next() {
            block14: {
                if (this.iter.hasNext()) {
                    try {
                        Handler<DeliveryContext> handler = this.iter.next();
                        if (handler != null) {
                            handler.handle(this);
                            break block14;
                        }
                        this.next();
                    }
                    catch (Throwable t) {
                        log.error("Failure in interceptor", t);
                    }
                } else {
                    ClusteredMessage cmsg;
                    boolean local = true;
                    if (this.message instanceof ClusteredMessage && (cmsg = (ClusteredMessage)this.message).isFromWire()) {
                        local = false;
                    }
                    Object m = HandlerRegistration.this.metric;
                    try {
                        VertxTracer tracer;
                        if (HandlerRegistration.this.bus.metrics != null) {
                            HandlerRegistration.this.bus.metrics.beginHandleMessage(m, local);
                        }
                        if ((tracer = this.context.tracer()) != null && !HandlerRegistration.this.src) {
                            this.message.trace = tracer.receiveRequest(this.context, this.message, this.message.isSend() ? "send" : "publish", this.message.headers, MessageTagExtractor.INSTANCE);
                            this.handler.handle(this.message);
                            if (this.message.replyAddress == null) {
                                tracer.sendResponse(this.context, null, this.message.trace, null, TagExtractor.empty());
                            }
                        } else {
                            this.handler.handle(this.message);
                        }
                        if (HandlerRegistration.this.bus.metrics != null) {
                            HandlerRegistration.this.bus.metrics.endHandleMessage(m, null);
                        }
                    }
                    catch (Exception e) {
                        log.error("Failed to handleMessage. address: " + this.message.address(), e);
                        if (HandlerRegistration.this.bus.metrics != null) {
                            HandlerRegistration.this.bus.metrics.endHandleMessage(m, e);
                        }
                        this.context.reportException(e);
                    }
                }
            }
        }

        @Override
        public boolean send() {
            return this.message.isSend();
        }

        @Override
        public Object body() {
            return this.message.receivedBody;
        }
    }
}

