/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DeploymentOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, DeploymentOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "config": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setConfig(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "extraClasspath": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setExtraClasspath(list);
                    break;
                }
                case "ha": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setHa((Boolean)member.getValue());
                    break;
                }
                case "instances": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setInstances(((Number)member.getValue()).intValue());
                    break;
                }
                case "isolatedClasses": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setIsolatedClasses(list);
                    break;
                }
                case "isolationGroup": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setIsolationGroup((String)member.getValue());
                    break;
                }
                case "maxWorkerExecuteTime": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxWorkerExecuteTime(((Number)member.getValue()).longValue());
                    break;
                }
                case "maxWorkerExecuteTimeUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMaxWorkerExecuteTimeUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "worker": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setWorker((Boolean)member.getValue());
                    break;
                }
                case "workerPoolName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setWorkerPoolName((String)member.getValue());
                    break;
                }
                case "workerPoolSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setWorkerPoolSize(((Number)member.getValue()).intValue());
                }
            }
        }
    }

    static void toJson(DeploymentOptions obj, JsonObject json) {
        DeploymentOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(DeploymentOptions obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getConfig() != null) {
            json.put("config", obj.getConfig());
        }
        if (obj.getExtraClasspath() != null) {
            array = new JsonArray();
            obj.getExtraClasspath().forEach(item -> array.add(item));
            json.put("extraClasspath", array);
        }
        json.put("ha", obj.isHa());
        json.put("instances", obj.getInstances());
        if (obj.getIsolatedClasses() != null) {
            array = new JsonArray();
            obj.getIsolatedClasses().forEach(item -> array.add(item));
            json.put("isolatedClasses", array);
        }
        if (obj.getIsolationGroup() != null) {
            json.put("isolationGroup", obj.getIsolationGroup());
        }
        json.put("maxWorkerExecuteTime", obj.getMaxWorkerExecuteTime());
        if (obj.getMaxWorkerExecuteTimeUnit() != null) {
            json.put("maxWorkerExecuteTimeUnit", obj.getMaxWorkerExecuteTimeUnit().name());
        }
        json.put("worker", obj.isWorker());
        if (obj.getWorkerPoolName() != null) {
            json.put("workerPoolName", obj.getWorkerPoolName());
        }
        json.put("workerPoolSize", obj.getWorkerPoolSize());
    }
}

