/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.PemTrustOptions;
import java.util.Base64;
import java.util.Map;

public class PemTrustOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, PemTrustOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "certPaths": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addCertPath((String)item);
                        }
                    });
                    break;
                }
                case "certValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addCertValue(Buffer.buffer(Base64.getDecoder().decode((String)item)));
                        }
                    });
                }
            }
        }
    }

    static void toJson(PemTrustOptions obj, JsonObject json) {
        PemTrustOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(PemTrustOptions obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getCertPaths() != null) {
            array = new JsonArray();
            obj.getCertPaths().forEach(item -> array.add((String)item));
            json.put("certPaths", array);
        }
        if (obj.getCertValues() != null) {
            array = new JsonArray();
            obj.getCertValues().forEach(item -> array.add(Base64.getEncoder().encodeToString(item.getBytes())));
            json.put("certValues", array);
        }
    }
}

