/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.json.JsonCodec;
import java.util.ArrayList;
import java.util.Map;

public class WebSocketConnectOptionsConverter
implements JsonCodec<WebSocketConnectOptions, JsonObject> {
    public static final WebSocketConnectOptionsConverter INSTANCE = new WebSocketConnectOptionsConverter();

    @Override
    public JsonObject encode(WebSocketConnectOptions value) {
        return value != null ? value.toJson() : null;
    }

    @Override
    public WebSocketConnectOptions decode(JsonObject value) {
        return value != null ? new WebSocketConnectOptions(value) : null;
    }

    @Override
    public Class<WebSocketConnectOptions> getTargetClass() {
        return WebSocketConnectOptions.class;
    }

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, WebSocketConnectOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "subProtocols": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setSubProtocols(list);
                    break;
                }
                case "version": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setVersion(WebsocketVersion.valueOf((String)member.getValue()));
                }
            }
        }
    }

    public static void toJson(WebSocketConnectOptions obj, JsonObject json) {
        WebSocketConnectOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(WebSocketConnectOptions obj, Map<String, Object> json) {
        if (obj.getSubProtocols() != null) {
            JsonArray array = new JsonArray();
            obj.getSubProtocols().forEach(item -> array.add((String)item));
            json.put("subProtocols", array);
        }
        if (obj.getVersion() != null) {
            json.put("version", obj.getVersion().name());
        }
    }
}

