/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.streams.WriteStream;

@VertxGen
public interface HttpServerResponse
extends WriteStream<Buffer> {
    @Override
    public HttpServerResponse exceptionHandler(Handler<Throwable> var1);

    public HttpServerResponse setWriteQueueMaxSize(int var1);

    public HttpServerResponse drainHandler(Handler<Void> var1);

    public int getStatusCode();

    @Fluent
    public HttpServerResponse setStatusCode(int var1);

    public String getStatusMessage();

    @Fluent
    public HttpServerResponse setStatusMessage(String var1);

    @Fluent
    public HttpServerResponse setChunked(boolean var1);

    public boolean isChunked();

    @CacheReturn
    public MultiMap headers();

    @Fluent
    public HttpServerResponse putHeader(String var1, String var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpServerResponse putHeader(CharSequence var1, CharSequence var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpServerResponse putHeader(String var1, Iterable<String> var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpServerResponse putHeader(CharSequence var1, Iterable<CharSequence> var2);

    @CacheReturn
    public MultiMap trailers();

    @Fluent
    public HttpServerResponse putTrailer(String var1, String var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpServerResponse putTrailer(CharSequence var1, CharSequence var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpServerResponse putTrailer(String var1, Iterable<String> var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpServerResponse putTrailer(CharSequence var1, Iterable<CharSequence> var2);

    @Fluent
    public HttpServerResponse closeHandler(@Nullable Handler<Void> var1);

    @Fluent
    public HttpServerResponse endHandler(@Nullable Handler<Void> var1);

    public Future<Void> write(String var1, String var2);

    public void write(String var1, String var2, Handler<AsyncResult<Void>> var3);

    @Override
    public Future<Void> write(String var1);

    @Override
    public void write(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public HttpServerResponse writeContinue();

    @Override
    public Future<Void> end(String var1);

    @Override
    public void end(String var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> end(String var1, String var2);

    public void end(String var1, String var2, Handler<AsyncResult<Void>> var3);

    @Override
    public Future<Void> end(Buffer var1);

    @Override
    public void end(Buffer var1, Handler<AsyncResult<Void>> var2);

    @Override
    public Future<Void> end();

    default public Future<Void> sendFile(String filename) {
        return this.sendFile(filename, 0L);
    }

    default public Future<Void> sendFile(String filename, long offset) {
        return this.sendFile(filename, offset, Long.MAX_VALUE);
    }

    default public Future<Void> sendFile(String filename, long offset, long length) {
        Promise<Void> promise = Promise.promise();
        this.sendFile(filename, offset, length, promise);
        return promise.future();
    }

    @Fluent
    default public HttpServerResponse sendFile(String filename, Handler<AsyncResult<Void>> resultHandler) {
        return this.sendFile(filename, 0L, resultHandler);
    }

    @Fluent
    default public HttpServerResponse sendFile(String filename, long offset, Handler<AsyncResult<Void>> resultHandler) {
        return this.sendFile(filename, offset, Long.MAX_VALUE, resultHandler);
    }

    @Fluent
    public HttpServerResponse sendFile(String var1, long var2, long var4, Handler<AsyncResult<Void>> var6);

    public void close();

    public boolean ended();

    public boolean closed();

    public boolean headWritten();

    @Fluent
    public HttpServerResponse headersEndHandler(@Nullable Handler<Void> var1);

    @Fluent
    public HttpServerResponse bodyEndHandler(@Nullable Handler<Void> var1);

    public long bytesWritten();

    public int streamId();

    @Fluent
    public HttpServerResponse push(HttpMethod var1, String var2, String var3, Handler<AsyncResult<HttpServerResponse>> var4);

    default public Future<HttpServerResponse> push(HttpMethod method, String host, String path) {
        Promise<HttpServerResponse> promise = Promise.promise();
        this.push(method, host, path, promise);
        return promise.future();
    }

    @Fluent
    public HttpServerResponse push(HttpMethod var1, String var2, MultiMap var3, Handler<AsyncResult<HttpServerResponse>> var4);

    default public Future<HttpServerResponse> push(HttpMethod method, String path, MultiMap headers) {
        Promise<HttpServerResponse> promise = Promise.promise();
        this.push(method, path, headers, promise);
        return promise.future();
    }

    @Fluent
    public HttpServerResponse push(HttpMethod var1, String var2, Handler<AsyncResult<HttpServerResponse>> var3);

    default public Future<HttpServerResponse> push(HttpMethod method, String path) {
        Promise<HttpServerResponse> promise = Promise.promise();
        this.push(method, path, promise);
        return promise.future();
    }

    @Fluent
    public HttpServerResponse push(HttpMethod var1, String var2, String var3, MultiMap var4, Handler<AsyncResult<HttpServerResponse>> var5);

    default public Future<HttpServerResponse> push(HttpMethod method, String host, String path, MultiMap headers) {
        Promise<HttpServerResponse> promise = Promise.promise();
        this.push(method, host, path, headers, promise);
        return promise.future();
    }

    default public void reset() {
        this.reset(0L);
    }

    public void reset(long var1);

    @Fluent
    public HttpServerResponse writeCustomFrame(int var1, int var2, Buffer var3);

    @Fluent
    default public HttpServerResponse writeCustomFrame(HttpFrame frame) {
        return this.writeCustomFrame(frame.type(), frame.flags(), frame.payload());
    }

    @Fluent
    default public HttpServerResponse setStreamPriority(StreamPriority streamPriority) {
        return this;
    }

    @Fluent
    public HttpServerResponse addCookie(Cookie var1);

    default public @Nullable Cookie removeCookie(String name) {
        return this.removeCookie(name, true);
    }

    public @Nullable Cookie removeCookie(String var1, boolean var2);
}

