/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file;

import io.vertx.core.file.FileSystemOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.json.JsonCodec;
import java.util.Map;

public class FileSystemOptionsConverter
implements JsonCodec<FileSystemOptions, JsonObject> {
    public static final FileSystemOptionsConverter INSTANCE = new FileSystemOptionsConverter();

    @Override
    public JsonObject encode(FileSystemOptions value) {
        return value != null ? value.toJson() : null;
    }

    @Override
    public FileSystemOptions decode(JsonObject value) {
        return value != null ? new FileSystemOptions(value) : null;
    }

    @Override
    public Class<FileSystemOptions> getTargetClass() {
        return FileSystemOptions.class;
    }

    static void fromJson(Iterable<Map.Entry<String, Object>> json, FileSystemOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "classPathResolvingEnabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setClassPathResolvingEnabled((Boolean)member.getValue());
                    break;
                }
                case "fileCacheDir": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setFileCacheDir((String)member.getValue());
                    break;
                }
                case "fileCachingEnabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setFileCachingEnabled((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(FileSystemOptions obj, JsonObject json) {
        FileSystemOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(FileSystemOptions obj, Map<String, Object> json) {
        json.put("classPathResolvingEnabled", obj.isClassPathResolvingEnabled());
        if (obj.getFileCacheDir() != null) {
            json.put("fileCacheDir", obj.getFileCacheDir());
        }
        json.put("fileCachingEnabled", obj.isFileCachingEnabled());
    }
}

