/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.http.ClientAuth;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.spi.json.JsonCodec;
import java.util.Map;

public class NetServerOptionsConverter
implements JsonCodec<NetServerOptions, JsonObject> {
    public static final NetServerOptionsConverter INSTANCE = new NetServerOptionsConverter();

    @Override
    public JsonObject encode(NetServerOptions value) {
        return value != null ? value.toJson() : null;
    }

    @Override
    public NetServerOptions decode(JsonObject value) {
        return value != null ? new NetServerOptions(value) : null;
    }

    @Override
    public Class<NetServerOptions> getTargetClass() {
        return NetServerOptions.class;
    }

    static void fromJson(Iterable<Map.Entry<String, Object>> json, NetServerOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "acceptBacklog": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setAcceptBacklog(((Number)member.getValue()).intValue());
                    break;
                }
                case "clientAuth": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setClientAuth(ClientAuth.valueOf((String)member.getValue()));
                    break;
                }
                case "host": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHost((String)member.getValue());
                    break;
                }
                case "port": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPort(((Number)member.getValue()).intValue());
                    break;
                }
                case "sni": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setSni((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(NetServerOptions obj, JsonObject json) {
        NetServerOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(NetServerOptions obj, Map<String, Object> json) {
        json.put("acceptBacklog", obj.getAcceptBacklog());
        if (obj.getClientAuth() != null) {
            json.put("clientAuth", obj.getClientAuth().name());
        }
        if (obj.getHost() != null) {
            json.put("host", obj.getHost());
        }
        json.put("port", obj.getPort());
        json.put("sni", obj.isSni());
    }
}

