/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.Http2HeadersAdaptor;
import io.vertx.core.http.impl.Http2ServerConnection;
import io.vertx.core.http.impl.Http2ServerResponseImpl;
import io.vertx.core.http.impl.Http2ServerStream;
import io.vertx.core.http.impl.HttpFrameImpl;
import io.vertx.core.http.impl.HttpServerRequestImpl;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.NettyFileUpload;
import io.vertx.core.http.impl.NettyFileUploadDataFactory;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import java.net.URISyntaxException;
import java.nio.channels.ClosedChannelException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

public class Http2ServerRequestImpl
extends Http2ServerStream
implements HttpServerRequest {
    private static final Logger log = LoggerFactory.getLogger(HttpServerRequestImpl.class);
    private final String serverOrigin;
    private final MultiMap headersMap;
    private final String scheme;
    private String path;
    private String query;
    private MultiMap params;
    private String absoluteURI;
    private MultiMap attributes;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private boolean streamEnded;
    private boolean ended;
    private Handler<HttpServerFileUpload> uploadHandler;
    private HttpPostRequestDecoder postRequestDecoder;
    private Handler<Throwable> exceptionHandler;
    private Handler<HttpFrame> customFrameHandler;
    private Handler<StreamPriority> streamPriorityHandler;

    public Http2ServerRequestImpl(Http2ServerConnection conn, Http2Stream stream, HttpServerMetrics metrics, String serverOrigin, Http2Headers headers, String contentEncoding, boolean writable, boolean streamEnded) {
        super(conn, stream, headers, contentEncoding, serverOrigin, writable);
        String scheme = headers.get((Object)":scheme") != null ? ((CharSequence)headers.get((Object)":scheme")).toString() : null;
        headers.remove((Object)":method");
        headers.remove((Object)":scheme");
        headers.remove((Object)":path");
        headers.remove((Object)":authority");
        Http2HeadersAdaptor headersMap = new Http2HeadersAdaptor(headers);
        this.serverOrigin = serverOrigin;
        this.streamEnded = streamEnded;
        this.scheme = scheme;
        this.headersMap = headersMap;
    }

    @Override
    void handleInterestedOpsChanged() {
        this.response.writabilityChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleException(Throwable cause) {
        boolean notify;
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            notify = !this.ended;
        }
        if (notify) {
            this.notifyException(cause);
        }
        this.response.handleException(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyException(Throwable failure) {
        Handler<Throwable> handler;
        InterfaceHttpData upload = null;
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            handler = this.exceptionHandler;
            if (this.postRequestDecoder != null) {
                upload = this.postRequestDecoder.currentPartialHttpData();
            }
        }
        if (handler != null) {
            handler.handle(failure);
        }
        if (upload instanceof NettyFileUpload) {
            ((NettyFileUpload)upload).handleException(failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleClose() {
        boolean notify;
        super.handleClose();
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            notify = !this.streamEnded;
        }
        if (notify) {
            this.notifyException(new ClosedChannelException());
        }
        this.response.handleClose();
    }

    @Override
    void handleCustomFrame(int type, int flags, Buffer buff) {
        if (this.customFrameHandler != null) {
            this.customFrameHandler.handle(new HttpFrameImpl(type, flags, buff));
        }
    }

    @Override
    void handleData(Buffer data) {
        if (this.postRequestDecoder != null) {
            try {
                this.postRequestDecoder.offer((HttpContent)new DefaultHttpContent(data.getByteBuf()));
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        if (this.dataHandler != null) {
            this.dataHandler.handle(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleEnd(MultiMap trailers) {
        Handler<Void> handler;
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            this.streamEnded = true;
            this.ended = true;
            if (this.postRequestDecoder != null) {
                try {
                    this.postRequestDecoder.offer((HttpContent)LastHttpContent.EMPTY_LAST_CONTENT);
                    while (this.postRequestDecoder.hasNext()) {
                        InterfaceHttpData data = this.postRequestDecoder.next();
                        if (!(data instanceof Attribute)) continue;
                        Attribute attr = (Attribute)data;
                        try {
                            this.formAttributes().add(attr.getName(), attr.getValue());
                        }
                        catch (Exception e) {
                            this.handleException(e);
                        }
                    }
                }
                catch (HttpPostRequestDecoder.EndOfDataDecoderException data) {
                }
                catch (Exception e) {
                    this.handleException(e);
                }
                finally {
                    this.postRequestDecoder.destroy();
                }
            }
            handler = this.endHandler;
        }
        if (handler != null) {
            handler.handle(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleReset(long errorCode) {
        boolean notify;
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            notify = !this.ended;
            this.ended = true;
        }
        if (notify) {
            this.notifyException(new StreamResetException(errorCode));
        }
        this.response.handleReset(errorCode);
    }

    private void checkEnded() {
        if (this.ended) {
            throw new IllegalStateException("Request has already been read");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            this.exceptionHandler = handler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest handler(Handler<Buffer> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.dataHandler = handler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest pause() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
            this.doPause();
        }
        return this;
    }

    @Override
    public HttpServerRequest resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest fetch(long amount) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
            this.doFetch(amount);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest endHandler(Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.endHandler = handler;
        }
        return this;
    }

    @Override
    public HttpVersion version() {
        return HttpVersion.HTTP_2;
    }

    @Override
    public boolean isSSL() {
        return ((Http2ServerConnection)this.conn).isSsl();
    }

    @Override
    public String uri() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String path() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            this.path = this.uri != null ? HttpUtils.parsePath(this.uri) : null;
            return this.path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String query() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            this.query = this.uri != null ? HttpUtils.parseQuery(this.uri) : null;
            return this.query;
        }
    }

    @Override
    public String scheme() {
        return this.scheme;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public long bytesRead() {
        return super.bytesRead();
    }

    @Override
    public Http2ServerResponseImpl response() {
        return this.response;
    }

    @Override
    public MultiMap headers() {
        return this.headersMap;
    }

    @Override
    public String getHeader(String headerName) {
        return this.headers().get(headerName);
    }

    @Override
    public String getHeader(CharSequence headerName) {
        return this.headers().get(headerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap params() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            if (this.params == null) {
                this.params = HttpUtils.params(this.uri());
            }
            return this.params;
        }
    }

    @Override
    public String getParam(String paramName) {
        return this.params().get(paramName);
    }

    @Override
    public SocketAddress remoteAddress() {
        return ((Http2ServerConnection)this.conn).remoteAddress();
    }

    @Override
    public SocketAddress localAddress() {
        return ((Http2ServerConnection)this.conn).localAddress();
    }

    @Override
    public SSLSession sslSession() {
        return ((Http2ServerConnection)this.conn).sslSession();
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return ((Http2ServerConnection)this.conn).peerCertificateChain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String absoluteURI() {
        if (this.method == HttpMethod.CONNECT) {
            return null;
        }
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            if (this.absoluteURI == null) {
                try {
                    this.absoluteURI = HttpUtils.absoluteURI(this.serverOrigin, this);
                }
                catch (URISyntaxException e) {
                    log.error((Object)"Failed to create abs uri", e);
                }
            }
            return this.absoluteURI;
        }
    }

    @Override
    public NetSocket netSocket() {
        return this.response.netSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest setExpectMultipart(boolean expect) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
            if (expect) {
                String contentType;
                if (this.postRequestDecoder == null && (contentType = this.headersMap.get((CharSequence)HttpHeaderNames.CONTENT_TYPE)) != null) {
                    io.netty.handler.codec.http.HttpMethod method = io.netty.handler.codec.http.HttpMethod.valueOf((String)this.rawMethod);
                    String lowerCaseContentType = contentType.toString().toLowerCase();
                    boolean isURLEncoded = lowerCaseContentType.startsWith(HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.toString());
                    if ((lowerCaseContentType.startsWith(HttpHeaderValues.MULTIPART_FORM_DATA.toString()) || isURLEncoded) && (method == io.netty.handler.codec.http.HttpMethod.POST || method == io.netty.handler.codec.http.HttpMethod.PUT || method == io.netty.handler.codec.http.HttpMethod.PATCH || method == io.netty.handler.codec.http.HttpMethod.DELETE)) {
                        DefaultHttpRequest req = new DefaultHttpRequest(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, method, this.uri);
                        req.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
                        this.postRequestDecoder = new HttpPostRequestDecoder((HttpDataFactory)new NettyFileUploadDataFactory(this.context, this, () -> this.uploadHandler), (HttpRequest)req);
                    }
                }
            } else {
                this.postRequestDecoder = null;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExpectMultipart() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            return this.postRequestDecoder != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest uploadHandler(@Nullable Handler<HttpServerFileUpload> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            if (handler != null) {
                this.checkEnded();
            }
            this.uploadHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap formAttributes() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            if (this.attributes == null) {
                this.attributes = new CaseInsensitiveHeaders();
            }
            return this.attributes;
        }
    }

    @Override
    public String getFormAttribute(String attributeName) {
        return this.formAttributes().get(attributeName);
    }

    @Override
    public ServerWebSocket upgrade() {
        throw new UnsupportedOperationException("HTTP/2 request cannot be upgraded to a websocket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnded() {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            return this.ended;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest customFrameHandler(Handler<HttpFrame> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            this.customFrameHandler = handler;
        }
        return this;
    }

    @Override
    public HttpConnection connection() {
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerRequest streamPriorityHandler(Handler<StreamPriority> handler) {
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            this.streamPriorityHandler = handler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handlePriorityChange(StreamPriority streamPriority) {
        Handler<StreamPriority> handler;
        boolean priorityChanged = false;
        Http2ServerConnection http2ServerConnection = (Http2ServerConnection)this.conn;
        synchronized (http2ServerConnection) {
            handler = this.streamPriorityHandler;
            if (streamPriority != null && !streamPriority.equals(this.streamPriority())) {
                this.priority(streamPriority);
                priorityChanged = true;
            }
        }
        if (handler != null && priorityChanged) {
            handler.handle(streamPriority);
        }
    }

    @Override
    public StreamPriority streamPriority() {
        return this.priority();
    }
}

