/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.Shareable;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class JsonArray
implements Iterable<Object>,
ClusterSerializable,
Shareable {
    private List<Object> list;

    public JsonArray(String json) {
        this.fromJson(json);
    }

    public JsonArray() {
        this.list = new ArrayList<Object>();
    }

    public JsonArray(List list) {
        this.list = list;
    }

    public JsonArray(Buffer buf) {
        this.fromBuffer(buf);
    }

    public String getString(int pos) {
        CharSequence cs = (CharSequence)this.list.get(pos);
        return cs == null ? null : cs.toString();
    }

    public Integer getInteger(int pos) {
        Number number = (Number)this.list.get(pos);
        if (number == null) {
            return null;
        }
        if (number instanceof Integer) {
            return (Integer)number;
        }
        return number.intValue();
    }

    public Long getLong(int pos) {
        Number number = (Number)this.list.get(pos);
        if (number == null) {
            return null;
        }
        if (number instanceof Long) {
            return (Long)number;
        }
        return number.longValue();
    }

    public Double getDouble(int pos) {
        Number number = (Number)this.list.get(pos);
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return (Double)number;
        }
        return number.doubleValue();
    }

    public Float getFloat(int pos) {
        Number number = (Number)this.list.get(pos);
        if (number == null) {
            return null;
        }
        if (number instanceof Float) {
            return (Float)number;
        }
        return Float.valueOf(number.floatValue());
    }

    public Boolean getBoolean(int pos) {
        return (Boolean)this.list.get(pos);
    }

    public JsonObject getJsonObject(int pos) {
        Object val = this.list.get(pos);
        if (val instanceof Map) {
            val = new JsonObject((Map)val);
        }
        return (JsonObject)val;
    }

    public JsonArray getJsonArray(int pos) {
        Object val = this.list.get(pos);
        if (val instanceof List) {
            val = new JsonArray((List)val);
        }
        return (JsonArray)val;
    }

    public byte[] getBinary(int pos) {
        String val = (String)this.list.get(pos);
        if (val == null) {
            return null;
        }
        return Base64.getDecoder().decode(val);
    }

    public Instant getInstant(int pos) {
        String val = (String)this.list.get(pos);
        if (val == null) {
            return null;
        }
        return Instant.from(DateTimeFormatter.ISO_INSTANT.parse(val));
    }

    public Object getValue(int pos) {
        Object val = this.list.get(pos);
        if (val instanceof Map) {
            val = new JsonObject((Map)val);
        } else if (val instanceof List) {
            val = new JsonArray((List)val);
        }
        return val;
    }

    public boolean hasNull(int pos) {
        return this.list.get(pos) == null;
    }

    public JsonArray add(Enum value) {
        this.list.add(value != null ? value.name() : null);
        return this;
    }

    public JsonArray add(CharSequence value) {
        this.list.add(value != null ? value.toString() : null);
        return this;
    }

    public JsonArray add(String value) {
        this.list.add(value);
        return this;
    }

    public JsonArray add(Integer value) {
        this.list.add(value);
        return this;
    }

    public JsonArray add(Long value) {
        this.list.add(value);
        return this;
    }

    public JsonArray add(Double value) {
        this.list.add(value);
        return this;
    }

    public JsonArray add(Float value) {
        this.list.add(value);
        return this;
    }

    public JsonArray add(Boolean value) {
        this.list.add(value);
        return this;
    }

    public JsonArray addNull() {
        this.list.add(null);
        return this;
    }

    public JsonArray add(JsonObject value) {
        this.list.add(value);
        return this;
    }

    public JsonArray add(JsonArray value) {
        this.list.add(value);
        return this;
    }

    public JsonArray add(byte[] value) {
        this.list.add(value != null ? Base64.getEncoder().encodeToString(value) : null);
        return this;
    }

    public JsonArray add(Instant value) {
        this.list.add(value != null ? DateTimeFormatter.ISO_INSTANT.format(value) : null);
        return this;
    }

    public JsonArray add(Object value) {
        value = Json.checkAndCopy(value, false);
        this.list.add(value);
        return this;
    }

    public JsonArray addAll(JsonArray array) {
        this.list.addAll(array.list);
        return this;
    }

    public boolean contains(Object value) {
        return this.list.contains(value);
    }

    public boolean remove(Object value) {
        return this.list.remove(value);
    }

    public Object remove(int pos) {
        Object removed = this.list.remove(pos);
        if (removed instanceof Map) {
            return new JsonObject((Map)removed);
        }
        if (removed instanceof ArrayList) {
            return new JsonArray((List)removed);
        }
        return removed;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public List getList() {
        return this.list;
    }

    public JsonArray clear() {
        this.list.clear();
        return this;
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iter(this.list.iterator());
    }

    public String encode() {
        return Json.encode(this.list);
    }

    public Buffer toBuffer() {
        return Json.encodeToBuffer(this.list);
    }

    public String encodePrettily() {
        return Json.encodePrettily(this.list);
    }

    @Override
    public JsonArray copy() {
        ArrayList<Object> copiedList = new ArrayList<Object>(this.list.size());
        for (Object val : this.list) {
            val = Json.checkAndCopy(val, true);
            copiedList.add(val);
        }
        return new JsonArray(copiedList);
    }

    public Stream<Object> stream() {
        return Json.asStream(this.iterator());
    }

    public String toString() {
        return this.encode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return JsonArray.arrayEquals(this.list, o);
    }

    static boolean arrayEquals(List<?> l1, Object o2) {
        List l2;
        if (o2 instanceof JsonArray) {
            l2 = ((JsonArray)o2).list;
        } else if (o2 instanceof List) {
            l2 = (List)o2;
        } else {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        Iterator iter = l2.iterator();
        for (Object entry : l1) {
            Object other = iter.next();
            if (!(entry == null ? other != null : !JsonObject.equals(entry, other))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public void writeToBuffer(Buffer buffer) {
        String encoded = this.encode();
        byte[] bytes = encoded.getBytes();
        buffer.appendInt(bytes.length);
        buffer.appendBytes(bytes);
    }

    @Override
    public int readFromBuffer(int pos, Buffer buffer) {
        int length = buffer.getInt(pos);
        int start = pos + 4;
        String encoded = buffer.getString(start, start + length);
        this.fromJson(encoded);
        return pos + length + 4;
    }

    private void fromJson(String json) {
        this.list = Json.decodeValue(json, List.class);
    }

    private void fromBuffer(Buffer buf) {
        this.list = Json.decodeValue(buf, List.class);
    }

    private class Iter
    implements Iterator<Object> {
        final Iterator<Object> listIter;

        Iter(Iterator<Object> listIter) {
            this.listIter = listIter;
        }

        @Override
        public boolean hasNext() {
            return this.listIter.hasNext();
        }

        @Override
        public Object next() {
            Object val = this.listIter.next();
            if (val instanceof Map) {
                val = new JsonObject((Map)val);
            } else if (val instanceof List) {
                val = new JsonArray((List)val);
            }
            return val;
        }

        @Override
        public void remove() {
            this.listIter.remove();
        }
    }
}

