/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.ReadStream;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

@VertxGen
public interface HttpServerRequest
extends ReadStream<Buffer> {
    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> var1);

    public HttpServerRequest handler(Handler<Buffer> var1);

    public HttpServerRequest pause();

    public HttpServerRequest resume();

    public HttpServerRequest fetch(long var1);

    public HttpServerRequest endHandler(Handler<Void> var1);

    public HttpVersion version();

    public HttpMethod method();

    public String rawMethod();

    public boolean isSSL();

    public @Nullable String scheme();

    public String uri();

    public @Nullable String path();

    public @Nullable String query();

    public @Nullable String host();

    public long bytesRead();

    @CacheReturn
    public HttpServerResponse response();

    @CacheReturn
    public MultiMap headers();

    public @Nullable String getHeader(String var1);

    public String getHeader(CharSequence var1);

    @CacheReturn
    public MultiMap params();

    public @Nullable String getParam(String var1);

    @CacheReturn
    public SocketAddress remoteAddress();

    @CacheReturn
    public SocketAddress localAddress();

    public SSLSession sslSession();

    @GenIgnore
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException;

    public String absoluteURI();

    @Fluent
    default public HttpServerRequest bodyHandler(@Nullable Handler<Buffer> bodyHandler) {
        if (bodyHandler != null) {
            Buffer body = Buffer.buffer();
            this.handler(body::appendBuffer);
            this.endHandler(v -> bodyHandler.handle(body));
        }
        return this;
    }

    @CacheReturn
    public NetSocket netSocket();

    @Fluent
    public HttpServerRequest setExpectMultipart(boolean var1);

    public boolean isExpectMultipart();

    @Fluent
    public HttpServerRequest uploadHandler(@Nullable Handler<HttpServerFileUpload> var1);

    @CacheReturn
    public MultiMap formAttributes();

    public @Nullable String getFormAttribute(String var1);

    public ServerWebSocket upgrade();

    public boolean isEnded();

    @Fluent
    public HttpServerRequest customFrameHandler(Handler<HttpFrame> var1);

    @CacheReturn
    public HttpConnection connection();
}

