/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.vertx.core.VertxException;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.HttpHandlers;
import io.vertx.core.http.impl.HttpServerImpl;
import io.vertx.core.http.impl.VertxHttpHandler;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.impl.HandlerHolder;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.spi.metrics.HttpServerMetrics;

public class Http1xServerHandler
extends VertxHttpHandler<Http1xServerConnection> {
    private static final Logger log = LoggerFactory.getLogger(Http1xServerHandler.class);
    private final SSLHelper sslHelper;
    private final HttpServerOptions options;
    private final String serverOrigin;
    private final HttpServerMetrics metrics;
    private final HandlerHolder<HttpHandlers> holder;

    public Http1xServerHandler(SSLHelper sslHelper, HttpServerOptions options, String serverOrigin, HandlerHolder<HttpHandlers> holder, HttpServerMetrics metrics) {
        this.holder = holder;
        this.metrics = metrics;
        this.sslHelper = sslHelper;
        this.options = options;
        this.serverOrigin = serverOrigin;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        Http1xServerConnection conn = new Http1xServerConnection(this.holder.context.owner(), this.sslHelper, this.options, ctx, this.holder.context, this.serverOrigin, this.metrics);
        this.setConnection(conn);
        conn.requestHandlers((HttpHandlers)this.holder.handler);
        if (this.metrics != null) {
            this.holder.context.executeFromIO(() -> conn.metric(this.metrics.connected(conn.remoteAddress(), conn.remoteName())));
        }
    }

    @Override
    protected void handleMessage(Http1xServerConnection conn, ContextImpl context, ChannelHandlerContext chctx, Object msg) throws Exception {
        conn.handleMessage(msg);
    }

    WebSocketServerHandshaker createHandshaker(Http1xServerConnection conn, Channel ch, HttpRequest request) {
        String connectionHeader = request.headers().get(HttpHeaders.CONNECTION);
        if (connectionHeader == null || !connectionHeader.toLowerCase().contains("upgrade")) {
            HttpServerImpl.sendError("\"Connection\" must be \"Upgrade\".", HttpResponseStatus.BAD_REQUEST, ch);
            return null;
        }
        if (request.getMethod() != HttpMethod.GET) {
            HttpServerImpl.sendError(null, HttpResponseStatus.METHOD_NOT_ALLOWED, ch);
            return null;
        }
        try {
            WebSocketServerHandshakerFactory factory = new WebSocketServerHandshakerFactory(HttpServerImpl.getWebSocketLocation(ch.pipeline(), request), conn.options.getWebsocketSubProtocols(), false, conn.options.getMaxWebsocketFrameSize(), conn.options.isAcceptUnmaskedFrames());
            WebSocketServerHandshaker shake = factory.newHandshaker(request);
            if (shake == null) {
                log.error("Unrecognised websockets handshake");
                WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ch);
            }
            return shake;
        }
        catch (Exception e) {
            throw new VertxException(e);
        }
    }
}

