/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.impl.Http2ConnectionBase;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import java.util.ArrayDeque;

abstract class VertxHttp2Stream<C extends Http2ConnectionBase> {
    protected final C conn;
    protected final VertxInternal vertx;
    protected final ContextImpl context;
    protected final ChannelHandlerContext handlerContext;
    protected final Http2Stream stream;
    private final ArrayDeque<Buffer> pending = new ArrayDeque(8);
    private boolean paused;
    private boolean ended;
    private MultiMap trailers;
    private boolean writable;

    VertxHttp2Stream(C conn, Http2Stream stream, boolean writable) {
        this.conn = conn;
        this.vertx = ((Http2ConnectionBase)conn).vertx();
        this.handlerContext = ((Http2ConnectionBase)conn).handlerContext;
        this.stream = stream;
        this.context = ((Http2ConnectionBase)conn).getContext();
        this.writable = writable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onResetRead(long code) {
        C c = this.conn;
        synchronized (c) {
            this.paused = false;
            this.pending.clear();
            this.handleReset(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onDataRead(Buffer data) {
        C c = this.conn;
        synchronized (c) {
            if (!this.paused) {
                if (this.pending.isEmpty()) {
                    this.handleData(data);
                    return true;
                }
                this.pending.add(data);
                this.checkNextTick(null);
            } else {
                this.pending.add(data);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onWritabilityChanged() {
        C c = this.conn;
        synchronized (c) {
            this.writable = !this.writable;
            this.handleInterestedOpsChanged();
        }
    }

    void onEnd() {
        this.onEnd(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onEnd(MultiMap map) {
        C c = this.conn;
        synchronized (c) {
            this.trailers = map;
            this.ended = true;
            if (this.pending.isEmpty()) {
                this.handleEnd(this.trailers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNextTick(Void v) {
        C c = this.conn;
        synchronized (c) {
            if (!this.paused) {
                Buffer buf = this.pending.poll();
                ((Http2ConnectionBase)this.conn).handler.consume(this.stream, buf.length());
                this.handleData(buf);
                if (this.pending.size() > 0) {
                    this.vertx.runOnContext(this::checkNextTick);
                } else if (this.ended) {
                    this.handleEnd(this.trailers);
                }
            }
        }
    }

    int id() {
        return this.stream.id();
    }

    public void doPause() {
        this.paused = true;
    }

    public void doResume() {
        this.paused = false;
        this.context.runOnContext(this::checkNextTick);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isNotWritable() {
        C c = this.conn;
        synchronized (c) {
            return !this.writable;
        }
    }

    void writeFrame(int type, int flags, ByteBuf payload) {
        ((Http2ConnectionBase)this.conn).handler.writeFrame(this.stream, (byte)type, (short)flags, payload);
    }

    void writeHeaders(Http2Headers headers, boolean end) {
        ((Http2ConnectionBase)this.conn).handler.writeHeaders(this.stream, headers, end);
    }

    void writeData(ByteBuf chunk, boolean end) {
        ((Http2ConnectionBase)this.conn).handler.writeData(this.stream, chunk, end);
    }

    void writeReset(long code) {
        ((Http2ConnectionBase)this.conn).handler.writeReset(this.stream.id(), code);
    }

    void handleInterestedOpsChanged() {
    }

    void handleData(Buffer buf) {
    }

    void handleCustomFrame(int type, int flags, Buffer buff) {
    }

    void handleEnd(MultiMap trailers) {
    }

    void handleReset(long errorCode) {
    }

    void handleException(Throwable cause) {
    }

    void handleClose() {
    }
}

