/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.ServiceHelper;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.spi.WebSocketFrameFactory;

@VertxGen
public interface WebSocketFrame {
    public static final WebSocketFrameFactory factory = ServiceHelper.loadFactory(WebSocketFrameFactory.class);

    public static WebSocketFrame binaryFrame(Buffer data, boolean isFinal) {
        return factory.binaryFrame(data, isFinal);
    }

    public static WebSocketFrame textFrame(String str, boolean isFinal) {
        return factory.textFrame(str, isFinal);
    }

    public static WebSocketFrame pingFrame(Buffer data) {
        return factory.pingFrame(data);
    }

    public static WebSocketFrame pongFrame(Buffer data) {
        return factory.pongFrame(data);
    }

    public static WebSocketFrame continuationFrame(Buffer data, boolean isFinal) {
        return factory.continuationFrame(data, isFinal);
    }

    public boolean isText();

    public boolean isBinary();

    public boolean isContinuation();

    public boolean isClose();

    @CacheReturn
    public String textData();

    @CacheReturn
    public Buffer binaryData();

    public boolean isFinal();

    public short closeStatusCode();

    public String closeReason();
}

