/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.Http1xClientHandler;
import io.vertx.core.http.impl.Http2ClientConnection;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.VertxHttp2ClientUpgradeCodec;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandlerBuilder;
import io.vertx.core.http.impl.pool.ConnectionListener;
import io.vertx.core.http.impl.pool.ConnectionProvider;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ChannelProvider;
import io.vertx.core.net.impl.ProxyChannelProvider;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import javax.net.ssl.SSLHandshakeException;

class HttpChannelConnector
implements ConnectionProvider<HttpClientConnection> {
    private final HttpClientImpl client;
    private final HttpClientOptions options;
    private final HttpClientMetrics metrics;
    private final SSLHelper sslHelper;
    private final HttpVersion version;
    private final long weight;
    private final long http1Weight;
    private final long http2Weight;
    private final long http2MaxConcurrency;
    private final long http1MaxConcurrency;
    private final boolean ssl;
    private final String peerHost;
    private final String host;
    private final int port;
    private final Object metric;

    HttpChannelConnector(HttpClientImpl client, Object metric, HttpVersion version, boolean ssl, String peerHost, String host, int port) {
        this.client = client;
        this.metric = metric;
        this.options = client.getOptions();
        this.metrics = client.metrics();
        this.sslHelper = client.getSslHelper();
        this.version = version;
        this.http1Weight = client.getOptions().getHttp2MaxPoolSize();
        this.http2Weight = client.getOptions().getMaxPoolSize();
        this.weight = version == HttpVersion.HTTP_2 ? this.http2Weight : this.http1Weight;
        this.http2MaxConcurrency = client.getOptions().getHttp2MultiplexingLimit() <= 0 ? Long.MAX_VALUE : (long)client.getOptions().getHttp2MultiplexingLimit();
        this.http1MaxConcurrency = client.getOptions().isPipelining() ? (long)client.getOptions().getPipeliningLimit() : 1L;
        this.ssl = ssl;
        this.peerHost = peerHost;
        this.host = host;
        this.port = port;
    }

    @Override
    public void close(HttpClientConnection conn) {
        conn.close();
    }

    @Override
    public long connect(final ConnectionListener<HttpClientConnection> listener, final ContextImpl context) {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group((EventLoopGroup)context.nettyEventLoop());
        bootstrap.channel(this.client.getVertx().transport().channelType(false));
        this.applyConnectionOptions(bootstrap);
        ChannelProvider channelProvider = this.options.getProxyOptions() == null || !this.ssl && this.options.getProxyOptions().getType() == ProxyType.HTTP ? ChannelProvider.INSTANCE : ProxyChannelProvider.INSTANCE;
        boolean useAlpn = this.options.isUseAlpn();
        Handler<Channel> channelInitializer = ch -> {
            final ChannelPipeline pipeline = ch.pipeline();
            if (this.ssl) {
                SslHandler sslHandler = new SslHandler(this.sslHelper.createEngine(this.client.getVertx(), this.peerHost, this.port, this.options.isForceSni() ? this.peerHost : null));
                ch.pipeline().addLast("ssl", (ChannelHandler)sslHandler);
                sslHandler.handshakeFuture().addListener(fut -> {
                    if (fut.isSuccess()) {
                        String protocol = sslHandler.applicationProtocol();
                        if (useAlpn) {
                            if ("h2".equals(protocol)) {
                                this.applyHttp2ConnectionOptions(ch.pipeline());
                                this.http2Connected(listener, context, (Channel)ch);
                            } else {
                                this.applyHttp1xConnectionOptions(ch.pipeline());
                                HttpVersion fallbackProtocol = "http/1.0".equals(protocol) ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1;
                                this.http1xConnected(listener, fallbackProtocol, this.host, this.port, true, context, (Channel)ch);
                            }
                        } else {
                            this.applyHttp1xConnectionOptions(ch.pipeline());
                            this.http1xConnected(listener, this.version, this.host, this.port, true, context, (Channel)ch);
                        }
                    } else {
                        this.handshakeFailure(context, (Channel)ch, fut.cause(), listener);
                    }
                });
            } else if (this.version == HttpVersion.HTTP_2) {
                if (this.client.getOptions().isHttp2ClearTextUpgrade()) {
                    final HttpClientCodec httpCodec = new HttpClientCodec();
                    VertxHttp2ClientUpgradeCodec upgradeCodec = new VertxHttp2ClientUpgradeCodec(this.client.getOptions().getInitialSettings(), (Channel)ch){
                        final /* synthetic */ Channel val$ch;
                        {
                            this.val$ch = channel;
                            super(settings);
                        }

                        @Override
                        public void upgradeTo(ChannelHandlerContext ctx, FullHttpResponse upgradeResponse) throws Exception {
                            HttpChannelConnector.this.applyHttp2ConnectionOptions(pipeline);
                            HttpChannelConnector.this.http2Connected(listener, context, this.val$ch);
                        }
                    };
                    HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)httpCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 65536);
                    class UpgradeRequestHandler
                    extends ChannelInboundHandlerAdapter {
                        final /* synthetic */ Channel val$ch;
                        final /* synthetic */ ConnectionListener val$listener;
                        final /* synthetic */ ContextImpl val$context;

                        UpgradeRequestHandler() {
                            this.val$ch = channel;
                            this.val$listener = connectionListener;
                            this.val$context = contextImpl;
                        }

                        public void channelActive(ChannelHandlerContext ctx) throws Exception {
                            DefaultFullHttpRequest upgradeRequest = new DefaultFullHttpRequest(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
                            String hostHeader = HttpChannelConnector.this.peerHost;
                            if (HttpChannelConnector.this.port != 80) {
                                hostHeader = hostHeader + ":" + HttpChannelConnector.this.port;
                            }
                            upgradeRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)hostHeader);
                            ctx.writeAndFlush((Object)upgradeRequest);
                            ctx.fireChannelActive();
                        }

                        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                            if (msg instanceof LastHttpContent) {
                                ChannelPipeline p = ctx.pipeline();
                                p.remove((ChannelHandler)httpCodec);
                                p.remove((ChannelHandler)this);
                                HttpChannelConnector.this.applyHttp1xConnectionOptions(this.val$ch.pipeline());
                                HttpChannelConnector.this.http1xConnected(this.val$listener, HttpVersion.HTTP_1_1, HttpChannelConnector.this.host, HttpChannelConnector.this.port, false, this.val$context, this.val$ch);
                            }
                        }

                        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                            super.userEventTriggered(ctx, evt);
                            if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL) {
                                ctx.pipeline().remove((ChannelHandler)this);
                            }
                        }
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{httpCodec, upgradeHandler, new UpgradeRequestHandler()});
                } else {
                    this.applyHttp2ConnectionOptions(pipeline);
                }
            } else {
                this.applyHttp1xConnectionOptions(pipeline);
            }
        };
        Handler<AsyncResult<Channel>> channelHandler = res -> {
            if (res.succeeded()) {
                Channel ch = (Channel)res.result();
                if (!this.ssl && ch.pipeline().get(HttpClientUpgradeHandler.class) == null) {
                    if (this.version == HttpVersion.HTTP_2 && !this.client.getOptions().isHttp2ClearTextUpgrade()) {
                        this.http2Connected(listener, context, ch);
                    } else {
                        this.http1xConnected(listener, this.version, this.host, this.port, false, context, ch);
                    }
                }
            } else {
                this.connectFailed(context, null, listener, res.cause());
            }
        };
        channelProvider.connect(this.client.getVertx(), bootstrap, this.client.getOptions().getProxyOptions(), SocketAddress.inetSocketAddress(this.port, this.host), channelInitializer, channelHandler);
        return this.weight;
    }

    private void applyConnectionOptions(Bootstrap bootstrap) {
        this.client.getVertx().transport().configure(this.options, bootstrap);
    }

    private void applyHttp2ConnectionOptions(ChannelPipeline pipeline) {
        if (this.client.getOptions().getIdleTimeout() > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, this.options.getIdleTimeout()));
        }
    }

    private void applyHttp1xConnectionOptions(ChannelPipeline pipeline) {
        if (this.client.getOptions().getLogActivity()) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler());
        }
        pipeline.addLast("codec", (ChannelHandler)new HttpClientCodec(this.client.getOptions().getMaxInitialLineLength(), this.client.getOptions().getMaxHeaderSize(), this.client.getOptions().getMaxChunkSize(), false, false, this.client.getOptions().getDecoderInitialBufferSize()));
        if (this.client.getOptions().isTryUseCompression()) {
            pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor(true));
        }
        if (this.client.getOptions().getIdleTimeout() > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, this.client.getOptions().getIdleTimeout()));
        }
    }

    private void handshakeFailure(ContextImpl context, Channel ch, Throwable cause, ConnectionListener<HttpClientConnection> listener) {
        SSLHandshakeException sslException = new SSLHandshakeException("Failed to create SSL connection");
        if (cause != null) {
            sslException.initCause(cause);
        }
        this.connectFailed(context, ch, listener, sslException);
    }

    private void http1xConnected(ConnectionListener<HttpClientConnection> listener, HttpVersion version, String host, int port, boolean ssl, ContextImpl context, Channel ch) {
        Http1xClientHandler clientHandler = new Http1xClientHandler(listener, context, version, host, port, ssl, this.client, this.metric, this.client.metrics());
        clientHandler.addHandler(conn -> listener.onConnectSuccess((HttpClientConnection)conn, this.http1MaxConcurrency, ch, context, this.weight, this.http1Weight));
        clientHandler.removeHandler(conn -> listener.onDiscard());
        ch.pipeline().addLast("handler", (ChannelHandler)clientHandler);
    }

    private void http2Connected(ConnectionListener<HttpClientConnection> listener, ContextImpl context, Channel ch) {
        try {
            boolean upgrade = ch.pipeline().get(SslHandler.class) == null && this.options.isHttp2ClearTextUpgrade();
            Http2ConnectionHandler handler = new VertxHttp2ConnectionHandlerBuilder(ch).server(false).clientUpgrade(upgrade).useCompression(this.client.getOptions().isTryUseCompression()).initialSettings(this.client.getOptions().getInitialSettings()).connectionFactory(connHandler -> new Http2ClientConnection(listener, this.metric, this.client, context, (VertxHttp2ConnectionHandler)((Object)connHandler), this.metrics)).logEnabled(this.options.getLogActivity()).build();
            handler.addHandler(conn -> {
                if (this.options.getHttp2ConnectionWindowSize() > 0) {
                    conn.setWindowSize(this.options.getHttp2ConnectionWindowSize());
                }
                if (this.metrics != null) {
                    Object metric = this.metrics.connected(conn.remoteAddress(), conn.remoteName());
                    conn.metric(metric);
                }
                long concurrency = conn.remoteSettings().getMaxConcurrentStreams();
                if (this.http2MaxConcurrency > 0L) {
                    concurrency = Math.min(concurrency, this.http2MaxConcurrency);
                }
                listener.onConnectSuccess((HttpClientConnection)conn, concurrency, ch, context, this.weight, this.http2Weight);
            });
            handler.removeHandler(conn -> {
                if (this.metrics != null) {
                    this.metrics.endpointDisconnected(this.metric, conn.metric());
                }
                listener.onDiscard();
            });
        }
        catch (Exception e) {
            this.connectFailed(context, ch, listener, e);
        }
    }

    private void connectFailed(ContextImpl context, Channel ch, ConnectionListener<HttpClientConnection> listener, Throwable t) {
        if (ch != null) {
            try {
                ch.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        listener.onConnectFailure(context, t, this.weight);
    }
}

