/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.GoAway;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.net.SocketAddress;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;

@VertxGen
public interface HttpConnection {
    default public int getWindowSize() {
        return -1;
    }

    @Fluent
    default public HttpConnection setWindowSize(int windowSize) {
        return this;
    }

    @Fluent
    default public HttpConnection goAway(long errorCode) {
        return this.goAway(errorCode, Integer.MAX_VALUE);
    }

    @Fluent
    default public HttpConnection goAway(long errorCode, int lastStreamId) {
        return this.goAway(errorCode, lastStreamId, null);
    }

    @Fluent
    public HttpConnection goAway(long var1, int var3, Buffer var4);

    @Fluent
    public HttpConnection goAwayHandler(@Nullable Handler<GoAway> var1);

    @Fluent
    public HttpConnection shutdownHandler(@Nullable Handler<Void> var1);

    @Fluent
    public HttpConnection shutdown();

    @Fluent
    public HttpConnection shutdown(long var1);

    @Fluent
    public HttpConnection closeHandler(Handler<Void> var1);

    public void close();

    public Http2Settings settings();

    @Fluent
    public HttpConnection updateSettings(Http2Settings var1);

    @Fluent
    public HttpConnection updateSettings(Http2Settings var1, Handler<AsyncResult<Void>> var2);

    public Http2Settings remoteSettings();

    @Fluent
    public HttpConnection remoteSettingsHandler(Handler<Http2Settings> var1);

    @Fluent
    public HttpConnection ping(Buffer var1, Handler<AsyncResult<Buffer>> var2);

    @Fluent
    public HttpConnection pingHandler(@Nullable Handler<Buffer> var1);

    @Fluent
    public HttpConnection exceptionHandler(Handler<Throwable> var1);

    @CacheReturn
    public SocketAddress remoteAddress();

    @CacheReturn
    public SocketAddress localAddress();

    public boolean isSsl();

    @GenIgnore
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException;

    public String indicatedServerName();
}

