/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.LinkedList;
import java.util.concurrent.Executor;

public class TaskQueue {
    static final Logger log = LoggerFactory.getLogger(TaskQueue.class);
    private final LinkedList<Runnable> tasks = new LinkedList();
    private boolean running;
    private final Runnable runner = () -> {
        while (true) {
            Runnable task;
            LinkedList<Runnable> linkedList = this.tasks;
            synchronized (linkedList) {
                task = this.tasks.poll();
                if (task == null) {
                    this.running = false;
                    return;
                }
            }
            try {
                task.run();
                continue;
            }
            catch (Throwable t) {
                log.error((Object)"Caught unexpected Throwable", t);
                continue;
            }
            break;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable task, Executor executor) {
        LinkedList<Runnable> linkedList = this.tasks;
        synchronized (linkedList) {
            this.tasks.add(task);
            if (!this.running) {
                this.running = true;
                executor.execute(this.runner);
            }
        }
    }
}

