/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientRequestImpl;
import io.vertx.core.http.impl.HttpClientResponseImpl;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.concurrent.TimeoutException;

abstract class HttpClientRequestBase
implements HttpClientRequest {
    private static final Logger log = LoggerFactory.getLogger(HttpClientRequestImpl.class);
    protected final HttpClientImpl client;
    protected final HttpMethod method;
    protected final String uri;
    protected final String path;
    protected final String host;
    protected final String query;
    private Handler<Throwable> exceptionHandler;
    private long currentTimeoutTimerId = -1L;
    private long lastDataReceived;
    protected boolean exceptionOccurred;
    private Object metric;

    HttpClientRequestBase(HttpClientImpl client, HttpMethod method, String host, String uri) {
        this.client = client;
        this.uri = uri;
        this.method = method;
        this.host = host;
        this.path = uri.length() > 0 ? HttpUtils.parsePath(uri) : "";
        this.query = HttpUtils.parseQuery(uri);
    }

    Object metric() {
        return this.metric;
    }

    void metric(Object metric) {
        this.metric = metric;
    }

    protected abstract Object getLock();

    protected abstract void doHandleResponse(HttpClientResponseImpl var1);

    protected abstract void checkComplete();

    @Override
    public String query() {
        return this.query;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
        Object object = this.getLock();
        synchronized (object) {
            if (handler != null) {
                this.checkComplete();
                this.exceptionHandler = handler;
            } else {
                this.exceptionHandler = null;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClientRequest setTimeout(long timeoutMs) {
        Object object = this.getLock();
        synchronized (object) {
            this.cancelOutstandingTimeoutTimer();
            this.currentTimeoutTimerId = this.client.getVertx().setTimer(timeoutMs, id -> this.handleTimeout(timeoutMs));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleException(Throwable t) {
        Object object = this.getLock();
        synchronized (object) {
            this.cancelOutstandingTimeoutTimer();
            this.exceptionOccurred = true;
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle(t);
            } else {
                log.error(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleResponse(HttpClientResponseImpl resp) {
        Object object = this.getLock();
        synchronized (object) {
            if (!this.exceptionOccurred) {
                this.cancelOutstandingTimeoutTimer();
                try {
                    this.doHandleResponse(resp);
                }
                catch (Throwable t) {
                    this.handleException(t);
                }
            }
        }
    }

    private void cancelOutstandingTimeoutTimer() {
        if (this.currentTimeoutTimerId != -1L) {
            this.client.getVertx().cancelTimer(this.currentTimeoutTimerId);
            this.currentTimeoutTimerId = -1L;
        }
    }

    private void handleTimeout(long timeoutMs) {
        if (this.lastDataReceived == 0L) {
            this.timeout(timeoutMs);
        } else {
            long now = System.currentTimeMillis();
            long timeSinceLastData = now - this.lastDataReceived;
            if (timeSinceLastData >= timeoutMs) {
                this.timeout(timeoutMs);
            } else {
                this.lastDataReceived = 0L;
                this.setTimeout(timeoutMs - timeSinceLastData);
            }
        }
    }

    private void timeout(long timeoutMs) {
        this.handleException(new TimeoutException("The timeout period of " + timeoutMs + "ms has been exceeded while executing " + (Object)((Object)this.method) + " " + this.uri + " for host " + this.host));
    }

    void handleResponseEnd() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dataReceived() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.currentTimeoutTimerId != -1L) {
                this.lastDataReceived = System.currentTimeMillis();
            }
        }
    }
}

