/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.FileStreamChannel;
import io.vertx.core.http.impl.Http2HeadersAdaptor;
import io.vertx.core.http.impl.Http2ServerConnection;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.core.http.impl.VertxHttp2Stream;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;

public class Http2ServerResponseImpl
implements HttpServerResponse {
    private static final Logger log = LoggerFactory.getLogger(Http2ServerResponseImpl.class);
    private final VertxHttp2Stream stream;
    private final ChannelHandlerContext ctx;
    private final Http2ServerConnection conn;
    private final boolean push;
    private final Object metric;
    private final String host;
    private Http2Headers headers = new DefaultHttp2Headers();
    private Http2HeadersAdaptor headersMap;
    private Http2Headers trailers;
    private Http2HeadersAdaptor trailedMap;
    private boolean chunked;
    private boolean headWritten;
    private boolean ended;
    private int statusCode = 200;
    private String statusMessage;
    private Handler<Void> drainHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> headersEndHandler;
    private Handler<Void> bodyEndHandler;
    private Handler<Void> closeHandler;
    private long bytesWritten;
    private int numPush;
    private boolean inHandler;

    public Http2ServerResponseImpl(Http2ServerConnection conn, VertxHttp2Stream stream, Object metric, boolean push, String contentEncoding, String host) {
        this.metric = metric;
        this.stream = stream;
        this.ctx = conn.handlerContext;
        this.conn = conn;
        this.push = push;
        this.host = host;
        if (contentEncoding != null) {
            this.putHeader((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (CharSequence)contentEncoding);
        }
    }

    public Http2ServerResponseImpl(Http2ServerConnection conn, VertxHttp2Stream stream, HttpMethod method, String path, boolean push, String contentEncoding) {
        this.stream = stream;
        this.ctx = conn.handlerContext;
        this.conn = conn;
        this.push = push;
        this.host = null;
        if (contentEncoding != null) {
            this.putHeader((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (CharSequence)contentEncoding);
        }
        this.metric = conn.metrics().responsePushed(conn.metric(), method, path, this);
    }

    synchronized void beginRequest() {
        this.inHandler = true;
    }

    synchronized boolean endRequest() {
        this.inHandler = false;
        return this.numPush > 0;
    }

    void callReset(long code) {
        this.handleEnded(true);
        this.handleError(new StreamResetException(code));
    }

    void handleError(Throwable cause) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(cause);
        }
    }

    void handleClose() {
        if (this.handleEnded(true)) {
            this.handleError(new ClosedChannelException());
        }
        if (this.closeHandler != null) {
            this.closeHandler.handle(null);
        }
    }

    private void checkHeadWritten() {
        if (this.headWritten) {
            throw new IllegalStateException("Header already sent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse exceptionHandler(Handler<Throwable> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
            this.exceptionHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getStatusCode() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            return this.statusCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setStatusCode(int statusCode) {
        if (statusCode < 0) {
            throw new IllegalArgumentException("code: " + statusCode + " (expected: 0+)");
        }
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.statusCode = statusCode;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStatusMessage() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (this.statusMessage == null) {
                return HttpResponseStatus.valueOf((int)this.statusCode).reasonPhrase();
            }
            return this.statusMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setStatusMessage(String statusMessage) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.statusMessage = statusMessage;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setChunked(boolean chunked) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.chunked = true;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isChunked() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            return this.chunked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap headers() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (this.headersMap == null) {
                this.headersMap = new Http2HeadersAdaptor(this.headers);
            }
            return this.headersMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(String name, String value) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.headers().add(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(CharSequence name, CharSequence value) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.headers().add(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(String name, Iterable<String> values) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.headers().add(name, values);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(CharSequence name, Iterable<CharSequence> values) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.headers().add(name, values);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap trailers() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (this.trailedMap == null) {
                this.trailers = new DefaultHttp2Headers();
                this.trailedMap = new Http2HeadersAdaptor(this.trailers);
            }
            return this.trailedMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(String name, String value) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
            this.trailers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(CharSequence name, CharSequence value) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
            this.trailers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(String name, Iterable<String> values) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
            this.trailers().set(name, values);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(CharSequence name, Iterable<CharSequence> value) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
            this.trailers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse closeHandler(Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
            this.closeHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse writeContinue() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.stream.writeHeaders(new DefaultHttp2Headers().status((CharSequence)"100"), false);
            this.ctx.flush();
            return this;
        }
    }

    @Override
    public HttpServerResponse write(Buffer chunk) {
        ByteBuf buf = chunk.getByteBuf();
        return this.write(buf);
    }

    @Override
    public HttpServerResponse write(String chunk, String enc) {
        return this.write(Buffer.buffer(chunk, enc).getByteBuf());
    }

    @Override
    public HttpServerResponse write(String chunk) {
        return this.write(Buffer.buffer(chunk).getByteBuf());
    }

    private Http2ServerResponseImpl write(ByteBuf chunk) {
        this.write(chunk, false);
        return this;
    }

    @Override
    public void end(String chunk) {
        this.end(Buffer.buffer(chunk));
    }

    @Override
    public void end(String chunk, String enc) {
        this.end(Buffer.buffer(chunk, enc));
    }

    @Override
    public void end(Buffer chunk) {
        this.end(chunk.getByteBuf());
    }

    @Override
    public void end() {
        this.end((ByteBuf)null);
    }

    void toNetSocket() {
        this.checkEnded();
        this.checkSendHeaders(false);
        this.handleEnded(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    private void end(ByteBuf chunk) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (chunk != null && !this.headers.contains((Object)HttpHeaderNames.CONTENT_LENGTH)) {
                this.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(chunk.readableBytes()));
            }
            this.write(chunk, true);
        }
    }

    private boolean checkSendHeaders(boolean end) {
        if (!this.headWritten) {
            if (this.headersEndHandler != null) {
                this.headersEndHandler.handle(null);
            }
            this.headWritten = true;
            this.headers.status((CharSequence)Integer.toString(this.statusCode));
            this.stream.writeHeaders(this.headers, end);
            if (end) {
                this.ctx.flush();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(ByteBuf chunk, boolean end) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
            if (end) {
                this.handleEnded(false);
            }
            boolean hasBody = chunk != null;
            boolean sent = this.checkSendHeaders(end && !hasBody && this.trailers == null);
            if (hasBody || !sent && end) {
                if (chunk == null) {
                    chunk = Unpooled.EMPTY_BUFFER;
                }
                int len = chunk.readableBytes();
                this.stream.writeData(chunk, end && this.trailers == null);
                this.bytesWritten += (long)len;
            }
            if (end && this.trailers != null) {
                this.stream.writeHeaders(this.trailers, true);
            }
            if (end && this.bodyEndHandler != null) {
                this.bodyEndHandler.handle(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse writeCustomFrame(int type, int flags, Buffer payload) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
            this.checkSendHeaders(false);
            this.stream.writeFrame(type, flags, payload.getByteBuf());
            this.ctx.flush();
            return this;
        }
    }

    private void checkEnded() {
        if (this.ended) {
            throw new IllegalStateException("Response has already been written");
        }
    }

    private boolean handleEnded(boolean failed) {
        if (!this.ended) {
            this.ended = true;
            if (this.metric != null) {
                if (failed) {
                    this.conn.metrics().requestReset(this.metric);
                } else {
                    this.conn.reportBytesWritten(this.bytesWritten);
                    this.conn.metrics().responseEnd(this.metric, this);
                }
            }
            return true;
        }
        return false;
    }

    void writabilityChanged() {
        if (!this.ended && !this.writeQueueFull() && this.drainHandler != null) {
            this.drainHandler.handle(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeQueueFull() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
            return this.stream.isNotWritable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setWriteQueueMaxSize(int maxSize) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse drainHandler(Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
            this.drainHandler = handler;
            return this;
        }
    }

    @Override
    public HttpServerResponse sendFile(String filename, long offset, long length) {
        return this.sendFile(filename, offset, length, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            String contentType;
            RandomAccessFile raf;
            this.checkEnded();
            ContextImpl resultCtx = resultHandler != null ? this.stream.vertx.getOrCreateContext() : null;
            File file = this.stream.vertx.resolveFile(filename);
            if (!file.exists()) {
                if (resultHandler != null) {
                    resultCtx.runOnContext(v -> resultHandler.handle(Future.failedFuture(new FileNotFoundException())));
                } else {
                    log.error("File not found: " + filename);
                }
                return this;
            }
            try {
                raf = new RandomAccessFile(file, "r");
            }
            catch (IOException e) {
                if (resultHandler != null) {
                    resultCtx.runOnContext(v -> resultHandler.handle(Future.failedFuture(e)));
                } else {
                    log.error((Object)"Failed to send file", e);
                }
                return this;
            }
            long contentLength = Math.min(length, file.length() - offset);
            if (this.headers.get((Object)HttpHeaderNames.CONTENT_LENGTH) == null) {
                this.putHeader((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(contentLength));
            }
            if (this.headers.get((Object)HttpHeaderNames.CONTENT_TYPE) == null && (contentType = MimeMapping.getMimeTypeForFilename(filename)) != null) {
                this.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)contentType);
            }
            this.checkSendHeaders(false);
            FileStreamChannel fileChannel = new FileStreamChannel(ar -> {
                if (ar.succeeded()) {
                    this.bytesWritten += ((Long)ar.result()).longValue();
                    this.end();
                }
                if (resultHandler != null) {
                    resultCtx.runOnContext(v -> resultHandler.handle(Future.succeededFuture()));
                }
            }, this.stream, offset, contentLength);
            this.drainHandler((Handler)fileChannel.drainHandler);
            this.ctx.channel().eventLoop().register((Channel)fileChannel);
            fileChannel.pipeline().fireUserEventTriggered((Object)raf);
        }
        return this;
    }

    @Override
    public void close() {
        this.conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ended() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            return this.ended;
        }
    }

    @Override
    public boolean closed() {
        return this.conn.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean headWritten() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            return this.headWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse headersEndHandler(@Nullable Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.headersEndHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse bodyEndHandler(@Nullable Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.bodyEndHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long bytesWritten() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            return this.bytesWritten;
        }
    }

    @Override
    public int streamId() {
        return this.stream.id();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(long code) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkEnded();
            this.handleEnded(true);
            this.stream.writeReset(code);
            this.ctx.flush();
        }
    }

    @Override
    public HttpServerResponse push(HttpMethod method, String host, String path, Handler<AsyncResult<HttpServerResponse>> handler) {
        return this.push(method, host, path, null, handler);
    }

    @Override
    public HttpServerResponse push(HttpMethod method, String path, MultiMap headers, Handler<AsyncResult<HttpServerResponse>> handler) {
        return this.push(method, null, path, headers, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse push(HttpMethod method, String host, String path, MultiMap headers, Handler<AsyncResult<HttpServerResponse>> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (this.push) {
                throw new IllegalStateException("A push response cannot promise another push");
            }
            this.checkEnded();
            this.conn.sendPush(this.stream.id(), host, method, headers, path, handler);
            if (!this.inHandler) {
                this.ctx.flush();
            }
            ++this.numPush;
            return this;
        }
    }

    @Override
    public HttpServerResponse push(HttpMethod method, String path, Handler<AsyncResult<HttpServerResponse>> handler) {
        return this.push(method, this.host, path, handler);
    }
}

