/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.Closeable;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.impl.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.KeyStoreHelper;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.PartialPooledByteBufAllocator;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.VertxNetHandler;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.TCPMetrics;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class NetClientImpl
implements NetClient,
MetricsProvider {
    private static final Logger log = LoggerFactory.getLogger(NetClientImpl.class);
    private final VertxInternal vertx;
    private final NetClientOptions options;
    private final SSLHelper sslHelper;
    private final Map<Channel, NetSocketImpl> socketMap = new ConcurrentHashMap<Channel, NetSocketImpl>();
    private final Closeable closeHook;
    private final ContextImpl creatingContext;
    private final TCPMetrics metrics;
    private volatile boolean closed;

    public NetClientImpl(VertxInternal vertx, NetClientOptions options) {
        this(vertx, options, true);
    }

    public NetClientImpl(VertxInternal vertx, NetClientOptions options, boolean useCreatingContext) {
        this.vertx = vertx;
        this.options = new NetClientOptions(options);
        this.sslHelper = new SSLHelper(options, KeyStoreHelper.create(vertx, options.getKeyCertOptions()), KeyStoreHelper.create(vertx, options.getTrustOptions()));
        this.closeHook = completionHandler -> {
            this.close();
            completionHandler.handle(Future.succeededFuture());
        };
        if (useCreatingContext) {
            this.creatingContext = vertx.getContext();
            if (this.creatingContext != null) {
                if (this.creatingContext.isMultiThreadedWorkerContext()) {
                    throw new IllegalStateException("Cannot use NetClient in a multi-threaded worker verticle");
                }
                this.creatingContext.addCloseHook(this.closeHook);
            }
        } else {
            this.creatingContext = null;
        }
        this.metrics = vertx.metricsSPI().createMetrics(this, options);
    }

    @Override
    public synchronized NetClient connect(int port, String host, Handler<AsyncResult<NetSocket>> connectHandler) {
        this.checkClosed();
        this.connect(port, host, connectHandler, this.options.getReconnectAttempts());
        return this;
    }

    @Override
    public void close() {
        if (!this.closed) {
            for (NetSocket netSocket : this.socketMap.values()) {
                netSocket.close();
            }
            if (this.creatingContext != null) {
                this.creatingContext.removeCloseHook(this.closeHook);
            }
            this.closed = true;
            this.metrics.close();
        }
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null && this.metrics.isEnabled();
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Client is closed");
        }
    }

    private void applyConnectionOptions(Bootstrap bootstrap) {
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)this.options.isTcpNoDelay());
        if (this.options.getSendBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.options.getSendBufferSize());
        }
        if (this.options.getReceiveBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)this.options.getReceiveBufferSize());
            bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(this.options.getReceiveBufferSize()));
        }
        bootstrap.option(ChannelOption.SO_LINGER, (Object)this.options.getSoLinger());
        if (this.options.getTrafficClass() != -1) {
            bootstrap.option(ChannelOption.IP_TOS, (Object)this.options.getTrafficClass());
        }
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.options.getConnectTimeout());
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)PartialPooledByteBufAllocator.INSTANCE);
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)this.options.isTcpKeepAlive());
    }

    private void connect(int port, String host, Handler<AsyncResult<NetSocket>> connectHandler, int remainingAttempts) {
        Objects.requireNonNull(host, "No null host accepted");
        Objects.requireNonNull(connectHandler, "No null connectHandler accepted");
        ContextImpl context = this.vertx.getOrCreateContext();
        this.sslHelper.validate(this.vertx);
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group((EventLoopGroup)context.eventLoop());
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                if (NetClientImpl.this.sslHelper.isSSL()) {
                    SslHandler sslHandler = NetClientImpl.this.sslHelper.createSslHandler(NetClientImpl.this.vertx, true);
                    pipeline.addLast("ssl", (ChannelHandler)sslHandler);
                }
                if (NetClientImpl.this.sslHelper.isSSL()) {
                    pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                }
                if (NetClientImpl.this.options.getIdleTimeout() > 0) {
                    pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, NetClientImpl.this.options.getIdleTimeout()));
                }
                pipeline.addLast("handler", (ChannelHandler)new VertxNetHandler(NetClientImpl.this.vertx, NetClientImpl.this.socketMap));
            }
        });
        this.applyConnectionOptions(bootstrap);
        ChannelFuture future = bootstrap.connect((SocketAddress)new InetSocketAddress(host, port));
        future.addListener(channelFuture -> {
            Channel ch = channelFuture.channel();
            if (channelFuture.isSuccess()) {
                if (this.sslHelper.isSSL()) {
                    SslHandler sslHandler = (SslHandler)ch.pipeline().get(SslHandler.class);
                    io.netty.util.concurrent.Future fut = sslHandler.handshakeFuture();
                    fut.addListener(future2 -> {
                        if (future2.isSuccess()) {
                            this.connected(context, ch, connectHandler);
                        } else {
                            this.failed(context, ch, future2.cause(), connectHandler);
                        }
                    });
                } else {
                    this.connected(context, ch, connectHandler);
                }
            } else if (remainingAttempts > 0 || remainingAttempts == -1) {
                context.executeFromIO(() -> {
                    log.debug("Failed to create connection. Will retry in " + this.options.getReconnectInterval() + " milliseconds");
                    this.vertx.setTimer(this.options.getReconnectInterval(), tid -> this.connect(port, host, connectHandler, remainingAttempts == -1 ? remainingAttempts : remainingAttempts - 1));
                });
            } else {
                this.failed(context, ch, channelFuture.cause(), connectHandler);
            }
        });
    }

    private void connected(ContextImpl context, Channel ch, Handler<AsyncResult<NetSocket>> connectHandler) {
        NetSocketImpl sock = new NetSocketImpl(this.vertx, ch, context, this.sslHelper, true, this.metrics);
        this.socketMap.put(ch, sock);
        context.executeFromIO(() -> {
            sock.setMetric(this.metrics.connected(sock.remoteAddress()));
            connectHandler.handle(Future.succeededFuture(sock));
        });
    }

    private void failed(ContextImpl context, Channel ch, Throwable t, Handler<AsyncResult<NetSocket>> connectHandler) {
        ch.close();
        context.executeFromIO(() -> NetClientImpl.doFailed(connectHandler, t));
    }

    private static void doFailed(Handler<AsyncResult<NetSocket>> connectHandler, Throwable t) {
        connectHandler.handle(Future.failedFuture(t));
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

