/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.impl.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.spi.metrics.NetworkMetrics;
import io.vertx.core.spi.metrics.TCPMetrics;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;

public abstract class ConnectionBase {
    private static final Logger log = LoggerFactory.getLogger(ConnectionBase.class);
    protected final VertxInternal vertx;
    protected final Channel channel;
    protected final ContextImpl context;
    protected final NetworkMetrics metrics;
    protected Handler<Throwable> exceptionHandler;
    protected Handler<Void> closeHandler;
    private boolean read;
    private boolean needsFlush;

    protected ConnectionBase(VertxInternal vertx, Channel channel, ContextImpl context, NetworkMetrics metrics) {
        this.vertx = vertx;
        this.channel = channel;
        this.context = context;
        this.metrics = metrics;
    }

    protected final synchronized void startRead() {
        this.checkContext();
        this.read = true;
    }

    protected final synchronized void endReadAndFlush() {
        this.read = false;
        if (this.needsFlush) {
            this.needsFlush = false;
            this.channel.flush();
        }
    }

    public synchronized ChannelFuture queueForWrite(Object obj) {
        this.needsFlush = true;
        return this.channel.write(obj);
    }

    public synchronized ChannelFuture writeToChannel(Object obj) {
        if (this.read) {
            return this.queueForWrite(obj);
        }
        if (this.channel.isOpen()) {
            return this.channel.writeAndFlush(obj);
        }
        return null;
    }

    public boolean isNotWritable() {
        return !this.channel.isWritable();
    }

    public void close() {
        this.endReadAndFlush();
        this.channel.close();
    }

    public void doPause() {
        this.channel.config().setAutoRead(false);
    }

    public void doResume() {
        this.channel.config().setAutoRead(true);
    }

    public void doSetWriteQueueMaxSize(int size) {
        this.channel.config().setWriteBufferLowWaterMark(size / 2);
        this.channel.config().setWriteBufferHighWaterMark(size);
    }

    protected void checkContext() {
        if (this.context != this.vertx.getContext()) {
            throw new IllegalStateException("Wrong context!");
        }
    }

    protected ContextImpl getContext() {
        return this.context;
    }

    protected abstract Object metric();

    protected synchronized void handleException(Throwable t) {
        this.metrics.exceptionOccurred(this.metric(), this.remoteAddress(), t);
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(t);
        } else {
            log.error(t);
        }
    }

    protected synchronized void handleClosed() {
        if (this.metrics instanceof TCPMetrics) {
            ((TCPMetrics)this.metrics).disconnected(this.metric(), this.remoteAddress());
        }
        if (this.closeHandler != null) {
            this.closeHandler.handle(null);
        }
    }

    protected abstract void handleInterestedOpsChanged();

    protected void addFuture(Handler<AsyncResult<Void>> completionHandler, ChannelFuture future) {
        if (future != null) {
            future.addListener(channelFuture -> this.context.executeFromIO(() -> {
                if (completionHandler != null) {
                    if (channelFuture.isSuccess()) {
                        completionHandler.handle(Future.succeededFuture());
                    } else {
                        completionHandler.handle(Future.failedFuture(channelFuture.cause()));
                    }
                } else if (!channelFuture.isSuccess()) {
                    this.handleException(channelFuture.cause());
                }
            }));
        }
    }

    protected boolean supportsFileRegion() {
        return !this.isSSL();
    }

    public void reportBytesRead(long numberOfBytes) {
        if (this.metrics.isEnabled()) {
            this.metrics.bytesRead(this.metric(), this.remoteAddress(), numberOfBytes);
        }
    }

    public void reportBytesWritten(long numberOfBytes) {
        if (this.metrics.isEnabled()) {
            this.metrics.bytesWritten(this.metric(), this.remoteAddress(), numberOfBytes);
        }
    }

    private boolean isSSL() {
        return this.channel.pipeline().get(SslHandler.class) != null;
    }

    protected ChannelFuture sendFile(RandomAccessFile raf, long fileLength) throws IOException {
        ChannelFuture writeFuture;
        if (!this.supportsFileRegion()) {
            writeFuture = this.writeToChannel(new ChunkedFile(raf, 0L, fileLength, 8192));
        } else {
            DefaultFileRegion region = new DefaultFileRegion(raf.getChannel(), 0L, fileLength);
            writeFuture = this.writeToChannel(region);
        }
        writeFuture.addListener(fut -> raf.close());
        return writeFuture;
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.isSSL()) {
            ChannelHandlerContext sslHandlerContext = this.channel.pipeline().context("ssl");
            assert (sslHandlerContext != null);
            SslHandler sslHandler = (SslHandler)sslHandlerContext.handler();
            return sslHandler.engine().getSession().getPeerCertificateChain();
        }
        return null;
    }

    public SocketAddress remoteAddress() {
        InetSocketAddress addr = (InetSocketAddress)this.channel.remoteAddress();
        if (addr == null) {
            return null;
        }
        return new SocketAddressImpl(addr.getPort(), addr.getAddress().getHostAddress());
    }

    public SocketAddress localAddress() {
        InetSocketAddress addr = (InetSocketAddress)this.channel.localAddress();
        if (addr == null) {
            return null;
        }
        return new SocketAddressImpl(addr.getPort(), addr.getAddress().getHostAddress());
    }
}

