/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl;

import io.vertx.core.Handler;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.MessageProducer;

public class MessageProducerImpl<T>
implements MessageProducer<T> {
    private final EventBus bus;
    private final boolean send;
    private final String address;
    private DeliveryOptions options;

    public MessageProducerImpl(EventBus bus, String address, boolean send, DeliveryOptions options) {
        this.bus = bus;
        this.address = address;
        this.send = send;
        this.options = options;
    }

    @Override
    public synchronized MessageProducer<T> deliveryOptions(DeliveryOptions options) {
        this.options = options;
        return this;
    }

    @Override
    public MessageProducer<T> exceptionHandler(Handler<Throwable> handler) {
        return this;
    }

    @Override
    public MessageProducer<T> setWriteQueueMaxSize(int maxSize) {
        return this;
    }

    @Override
    public synchronized MessageProducer<T> write(T data) {
        if (this.send) {
            this.bus.send(this.address, data, this.options);
        } else {
            this.bus.publish(this.address, data, this.options);
        }
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        return false;
    }

    @Override
    public MessageProducer<T> drainHandler(Handler<Void> handler) {
        return this;
    }

    @Override
    public String address() {
        return this.address;
    }
}

