/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.datagram.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramPacket;
import io.vertx.core.datagram.impl.DatagramPacketImpl;
import io.vertx.core.datagram.impl.DatagramSocketImpl;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.impl.VertxHandler;
import java.net.InetSocketAddress;
import java.util.HashMap;

final class DatagramServerHandler
extends VertxHandler<DatagramSocketImpl> {
    private final DatagramSocketImpl server;

    DatagramServerHandler(VertxInternal vertx, DatagramSocketImpl server) {
        super(vertx, new HashMap());
        this.server = server;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.connectionMap.put(ctx.channel(), this.server);
    }

    @Override
    protected void channelRead(DatagramSocketImpl server, ContextImpl context, ChannelHandlerContext chctx, Object msg) throws Exception {
        context.executeSync(() -> server.handlePacket((DatagramPacket)msg));
    }

    @Override
    protected Object safeObject(Object msg, ByteBufAllocator allocator) throws Exception {
        if (msg instanceof io.netty.channel.socket.DatagramPacket) {
            io.netty.channel.socket.DatagramPacket packet = (io.netty.channel.socket.DatagramPacket)msg;
            ByteBuf content = (ByteBuf)packet.content();
            if (content.isDirect()) {
                content = DatagramServerHandler.safeBuffer(content, allocator);
            }
            return new DatagramPacketImpl((InetSocketAddress)packet.sender(), Buffer.buffer(content));
        }
        return msg;
    }
}

