/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.shareddata.Lock;
import java.util.LinkedList;
import java.util.Queue;

public class AsynchronousLock
implements Lock {
    private final VertxInternal vertx;
    private Queue<LockWaiter> waiters = new LinkedList<LockWaiter>();
    private boolean owned;

    public AsynchronousLock(VertxInternal vertx) {
        this.vertx = vertx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(long timeout, Handler<AsyncResult<Lock>> resultHandler) {
        ContextImpl context = this.vertx.getOrCreateContext();
        AsynchronousLock asynchronousLock = this;
        synchronized (asynchronousLock) {
            if (!this.owned) {
                this.owned = true;
                this.lockAquired(context, resultHandler);
            } else {
                this.waiters.add(new LockWaiter(this, context, timeout, resultHandler));
            }
        }
    }

    @Override
    public synchronized void release() {
        LockWaiter waiter = this.pollWaiters();
        if (waiter != null) {
            waiter.acquire(this);
        } else {
            this.owned = false;
        }
    }

    private void lockAquired(Context context, Handler<AsyncResult<Lock>> resultHandler) {
        context.runOnContext(v -> resultHandler.handle(Future.succeededFuture(this)));
    }

    private LockWaiter pollWaiters() {
        LockWaiter waiter;
        do {
            if ((waiter = this.waiters.poll()) != null) continue;
            return null;
        } while (waiter.timedOut);
        return waiter;
    }

    private class LockWaiter {
        final AsynchronousLock lock;
        final Context context;
        final Handler<AsyncResult<Lock>> resultHandler;
        volatile boolean timedOut;
        volatile boolean acquired;

        LockWaiter(AsynchronousLock lock, Context context, long timeout, Handler<AsyncResult<Lock>> resultHandler) {
            this.lock = lock;
            this.context = context;
            this.resultHandler = resultHandler;
            if (timeout != Long.MAX_VALUE) {
                AsynchronousLock.this.vertx.setTimer(timeout, tid -> this.timedOut());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void timedOut() {
            AsynchronousLock asynchronousLock = this.lock;
            synchronized (asynchronousLock) {
                if (!this.acquired) {
                    this.timedOut = true;
                    this.context.runOnContext(v -> this.resultHandler.handle(Future.failedFuture(new VertxException("Timed out waiting to get lock"))));
                }
            }
        }

        void acquire(AsynchronousLock lock) {
            this.acquired = true;
            lock.lockAquired(this.context, this.resultHandler);
        }
    }
}

