/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.logging.impl;

import io.vertx.core.logging.impl.JULLogDelegate;
import io.vertx.core.logging.impl.LogDelegate;
import io.vertx.core.logging.impl.LogDelegateFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.LogManager;

public class JULLogDelegateFactory
implements LogDelegateFactory {
    @Override
    public LogDelegate createDelegate(String name) {
        return new JULLogDelegate(name);
    }

    static {
        if (System.getProperty("java.util.logging.config.file") == null) {
            try (InputStream is = JULLogDelegateFactory.class.getClassLoader().getResourceAsStream("vertx-default-jul-logging.properties");){
                if (is != null) {
                    LogManager.getLogManager().readConfiguration(is);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

