/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import java.net.URL;
import java.net.URLClassLoader;

public class IsolatingClassLoader
extends URLClassLoader {
    IsolatingClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                if (this.isVertxOrSystemClass(name)) {
                    try {
                        c = super.loadClass(name, false);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (c == null) {
                    try {
                        c = this.findClass(name);
                    }
                    catch (ClassNotFoundException e) {
                        c = super.loadClass(name, false);
                    }
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    private boolean isVertxOrSystemClass(String name) {
        return name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("com.sun.") || name.startsWith("io.vertx.core") || name.startsWith("com.hazelcast") || name.startsWith("io.netty.") || name.startsWith("com.fasterxml.jackson");
    }
}

