/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.impl.FrameType;
import io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import java.util.UUID;

public abstract class WebSocketImplBase
implements WebSocketBase {
    private final boolean supportsContinuation;
    private final String textHandlerID;
    private final String binaryHandlerID;
    private final VertxInternal vertx;
    private final int maxWebSocketFrameSize;
    private final MessageConsumer binaryHandlerRegistration;
    private final MessageConsumer textHandlerRegistration;
    protected final ConnectionBase conn;
    protected Handler<WebSocketFrame> frameHandler;
    protected Handler<Buffer> dataHandler;
    protected Handler<Void> drainHandler;
    protected Handler<Throwable> exceptionHandler;
    protected Handler<Void> closeHandler;
    protected Handler<Void> endHandler;
    protected boolean closed;

    protected WebSocketImplBase(VertxInternal vertx, ConnectionBase conn, boolean supportsContinuation, int maxWebSocketFrameSize) {
        this.supportsContinuation = supportsContinuation;
        this.vertx = vertx;
        this.textHandlerID = UUID.randomUUID().toString();
        this.binaryHandlerID = UUID.randomUUID().toString();
        this.conn = conn;
        Handler<Message> binaryHandler = msg -> this.writeBinaryFrameInternal((Buffer)msg.body());
        this.binaryHandlerRegistration = vertx.eventBus().localConsumer(this.binaryHandlerID).handler(binaryHandler);
        Handler<Message> textHandler = msg -> this.writeTextFrameInternal((String)msg.body());
        this.textHandlerRegistration = vertx.eventBus().localConsumer(this.textHandlerID).handler(textHandler);
        this.maxWebSocketFrameSize = maxWebSocketFrameSize;
    }

    @Override
    public String binaryHandlerID() {
        return this.binaryHandlerID;
    }

    @Override
    public String textHandlerID() {
        return this.textHandlerID;
    }

    @Override
    public synchronized boolean writeQueueFull() {
        this.checkClosed();
        return this.conn.isNotWritable();
    }

    @Override
    public synchronized void close() {
        this.checkClosed();
        this.conn.close();
        this.cleanupHandlers();
    }

    @Override
    public SocketAddress localAddress() {
        return this.conn.localAddress();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.conn.remoteAddress();
    }

    @Override
    public abstract WebSocketBase exceptionHandler(Handler<Throwable> var1);

    protected void writeMessageInternal(Buffer data) {
        this.checkClosed();
        this.writePartialMessage(data, 0);
    }

    protected void writePartialMessage(Buffer data, int offset) {
        boolean isFinal;
        int end = offset + this.maxWebSocketFrameSize;
        if (end >= data.length()) {
            end = data.length();
            isFinal = true;
        } else {
            isFinal = false;
        }
        Buffer slice = data.slice(offset, end);
        WebSocketFrame frame = offset == 0 || !this.supportsContinuation ? WebSocketFrame.binaryFrame(slice, isFinal) : WebSocketFrame.continuationFrame(slice, isFinal);
        this.writeFrame(frame);
        int newOffset = offset + this.maxWebSocketFrameSize;
        if (!isFinal) {
            this.writePartialMessage(data, newOffset);
        }
    }

    protected void writeBinaryFrameInternal(Buffer data) {
        ByteBuf buf = data.getByteBuf();
        WebSocketFrameImpl frame = new WebSocketFrameImpl(FrameType.BINARY, buf);
        this.writeFrame(frame);
    }

    protected void writeTextFrameInternal(String str) {
        WebSocketFrameImpl frame = new WebSocketFrameImpl(str);
        this.writeFrame(frame);
    }

    protected synchronized void writeFrameInternal(WebSocketFrame frame) {
        this.checkClosed();
        if (this.conn.netMetrics().isEnabled()) {
            this.conn.netMetrics().bytesWritten(this.remoteAddress(), frame.binaryData().length());
        }
        this.conn.writeToChannel(frame);
    }

    protected void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("WebSocket is closed");
        }
    }

    synchronized void handleFrame(WebSocketFrameInternal frame) {
        if (this.conn.netMetrics().isEnabled()) {
            this.conn.netMetrics().bytesRead(this.remoteAddress(), frame.binaryData().length());
        }
        if (this.dataHandler != null) {
            Buffer buff = Buffer.buffer(frame.getBinaryData());
            this.dataHandler.handle(buff);
        }
        if (this.frameHandler != null) {
            this.frameHandler.handle(frame);
        }
    }

    void writable() {
        if (this.drainHandler != null) {
            Handler<Void> dh = this.drainHandler;
            this.drainHandler = null;
            dh.handle(null);
        }
    }

    synchronized void handleException(Throwable t) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(t);
        }
    }

    synchronized void handleClosed() {
        this.cleanupHandlers();
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
        if (this.closeHandler != null) {
            this.closeHandler.handle(null);
        }
    }

    private void cleanupHandlers() {
        if (!this.closed) {
            this.binaryHandlerRegistration.unregister();
            this.textHandlerRegistration.unregister();
            this.closed = true;
        }
    }
}

