/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VoidHandler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.impl.LoggerFactory;
import io.vertx.core.metrics.spi.NetMetrics;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.SSLHelper;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.UUID;

public class NetSocketImpl
extends ConnectionBase
implements NetSocket {
    private static final Logger log = LoggerFactory.getLogger(NetSocketImpl.class);
    private final String writeHandlerID;
    private final MessageConsumer registration;
    private final SSLHelper helper;
    private final boolean client;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private Handler<Void> drainHandler;
    private Queue<Buffer> pendingData;
    private boolean paused = false;
    private ChannelFuture writeFuture;

    public NetSocketImpl(VertxInternal vertx, Channel channel, ContextImpl context, SSLHelper helper, boolean client, NetMetrics metrics) {
        super(vertx, channel, context, metrics);
        this.helper = helper;
        this.client = client;
        this.writeHandlerID = UUID.randomUUID().toString();
        Handler<Message> writeHandler = msg -> this.write((Buffer)msg.body());
        this.registration = vertx.eventBus().localConsumer(this.writeHandlerID).handler(writeHandler);
    }

    @Override
    public String writeHandlerID() {
        return this.writeHandlerID;
    }

    @Override
    public NetSocket write(Buffer data) {
        ByteBuf buf = data.getByteBuf();
        this.write(buf);
        return this;
    }

    @Override
    public NetSocket write(String str) {
        this.write(Unpooled.copiedBuffer((CharSequence)str, (Charset)CharsetUtil.UTF_8));
        return this;
    }

    @Override
    public NetSocket write(String str, String enc) {
        if (enc == null) {
            this.write(str);
        } else {
            this.write(Unpooled.copiedBuffer((CharSequence)str, (Charset)Charset.forName(enc)));
        }
        return this;
    }

    @Override
    public synchronized NetSocket handler(Handler<Buffer> dataHandler) {
        this.dataHandler = dataHandler;
        return this;
    }

    @Override
    public synchronized NetSocket pause() {
        this.paused = true;
        this.doPause();
        return this;
    }

    @Override
    public synchronized NetSocket resume() {
        if (!this.paused) {
            return this;
        }
        this.paused = false;
        if (this.pendingData != null) {
            Buffer buf;
            while ((buf = this.pendingData.poll()) != null) {
                this.vertx.runOnContext(new VoidHandler(){

                    @Override
                    protected void handle() {
                        NetSocketImpl.this.handleDataReceived(buf);
                    }
                });
            }
        }
        this.doResume();
        return this;
    }

    @Override
    public NetSocket setWriteQueueMaxSize(int maxSize) {
        this.doSetWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        return this.isNotWritable();
    }

    @Override
    public synchronized NetSocket endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return this;
    }

    @Override
    public synchronized NetSocket drainHandler(Handler<Void> drainHandler) {
        this.drainHandler = drainHandler;
        this.vertx.runOnContext(v -> this.callDrainHandler());
        return this;
    }

    @Override
    public NetSocket sendFile(String filename) {
        return this.sendFile(filename, null);
    }

    @Override
    public NetSocket sendFile(String filename, Handler<AsyncResult<Void>> resultHandler) {
        File f = this.vertx.resolveFile(filename);
        if (f.isDirectory()) {
            throw new IllegalArgumentException("filename must point to a file and not to a directory");
        }
        try {
            RandomAccessFile raf = new RandomAccessFile(f, "r");
            ChannelFuture future = super.sendFile(raf, f.length());
            if (resultHandler != null) {
                future.addListener(fut -> {
                    Future res = future.isSuccess() ? Future.succeededFuture() : Future.failedFuture(future.cause());
                    this.vertx.runOnContext(v -> resultHandler.handle(res));
                });
            }
        }
        catch (IOException e) {
            if (resultHandler != null) {
                this.vertx.runOnContext(v -> resultHandler.handle(Future.failedFuture(e)));
            }
            log.error("Failed to send file", e);
        }
        return this;
    }

    @Override
    public SocketAddress remoteAddress() {
        return super.remoteAddress();
    }

    @Override
    public SocketAddress localAddress() {
        return super.localAddress();
    }

    @Override
    public synchronized NetSocket exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public synchronized NetSocket closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
        return this;
    }

    @Override
    public synchronized void close() {
        if (this.writeFuture != null) {
            this.writeFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            this.channel.flush();
        } else {
            super.close();
        }
    }

    @Override
    public synchronized NetSocket upgradeToSsl(Handler<Void> handler) {
        SslHandler sslHandler = (SslHandler)this.channel.pipeline().get(SslHandler.class);
        if (sslHandler == null) {
            sslHandler = this.helper.createSslHandler(this.vertx, this.client);
            this.channel.pipeline().addFirst(new ChannelHandler[]{sslHandler});
        }
        sslHandler.handshakeFuture().addListener(future -> this.context.executeSync(() -> {
            if (future.isSuccess()) {
                handler.handle(null);
            } else {
                log.error(future.cause());
            }
        }));
        return this;
    }

    @Override
    public boolean isSsl() {
        return this.channel.pipeline().get(SslHandler.class) != null;
    }

    @Override
    protected synchronized void handleInterestedOpsChanged() {
        this.checkContext();
        this.callDrainHandler();
    }

    @Override
    protected synchronized void handleClosed() {
        this.checkContext();
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
        super.handleClosed();
        if (this.vertx.eventBus() != null) {
            this.registration.unregister();
        }
    }

    synchronized void handleDataReceived(Buffer data) {
        this.checkContext();
        if (this.paused) {
            if (this.pendingData == null) {
                this.pendingData = new ArrayDeque<Buffer>();
            }
            this.pendingData.add(data);
            return;
        }
        if (this.metrics.isEnabled()) {
            this.metrics.bytesRead(this.remoteAddress(), data.length());
        }
        if (this.dataHandler != null) {
            this.dataHandler.handle(data);
        }
    }

    private void write(ByteBuf buff) {
        if (this.metrics.isEnabled()) {
            this.metrics.bytesWritten(this.remoteAddress(), buff.readableBytes());
        }
        this.writeFuture = super.writeToChannel(buff);
    }

    private synchronized void callDrainHandler() {
        if (this.drainHandler != null && !this.writeQueueFull()) {
            this.drainHandler.handle(null);
        }
    }
}

