/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.Options;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.KeyStoreOptions;
import io.vertx.core.net.TrustStoreOptions;

@Options
public class PKCS12Options
implements KeyStoreOptions,
TrustStoreOptions,
Cloneable {
    private String password;
    private String path;
    private Buffer value;

    public PKCS12Options() {
    }

    public PKCS12Options(PKCS12Options other) {
        this.password = other.getPassword();
        this.path = other.getPath();
        this.value = other.getValue();
    }

    public PKCS12Options(JsonObject json) {
        this.password = json.getString("password");
        this.path = json.getString("path");
        byte[] value = json.getBinary("value");
        this.value = value != null ? Buffer.buffer(value) : null;
    }

    public String getPassword() {
        return this.password;
    }

    public PKCS12Options setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public PKCS12Options setPath(String path) {
        this.path = path;
        return this;
    }

    public Buffer getValue() {
        return this.value;
    }

    public PKCS12Options setValue(Buffer value) {
        this.value = value;
        return this;
    }

    @Override
    public PKCS12Options clone() {
        return new PKCS12Options(this);
    }
}

