/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.eventbus.impl;

import io.netty.util.CharsetUtil;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.eventbus.ReplyException;
import org.vertx.java.core.eventbus.ReplyFailure;
import org.vertx.java.core.eventbus.impl.BooleanMessage;
import org.vertx.java.core.eventbus.impl.BufferMessage;
import org.vertx.java.core.eventbus.impl.ByteArrayMessage;
import org.vertx.java.core.eventbus.impl.CharacterMessage;
import org.vertx.java.core.eventbus.impl.DefaultEventBus;
import org.vertx.java.core.eventbus.impl.DoubleMessage;
import org.vertx.java.core.eventbus.impl.FloatMessage;
import org.vertx.java.core.eventbus.impl.IntMessage;
import org.vertx.java.core.eventbus.impl.JsonArrayMessage;
import org.vertx.java.core.eventbus.impl.JsonObjectMessage;
import org.vertx.java.core.eventbus.impl.LongMessage;
import org.vertx.java.core.eventbus.impl.ReplyFailureMessage;
import org.vertx.java.core.eventbus.impl.ShortMessage;
import org.vertx.java.core.eventbus.impl.StringMessage;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.net.NetSocket;
import org.vertx.java.core.net.impl.ServerID;

public abstract class BaseMessage<U>
implements Message<U> {
    protected U body;
    protected ServerID sender;
    protected DefaultEventBus bus;
    protected String address;
    protected String replyAddress;
    protected boolean send;

    protected BaseMessage(boolean send, String address, U body) {
        this.send = send;
        this.body = body;
        this.address = address;
    }

    @Override
    public U body() {
        return this.body;
    }

    @Override
    public String replyAddress() {
        return this.replyAddress;
    }

    @Override
    public void reply() {
        this.sendReply(DefaultEventBus.createMessage(true, this.replyAddress, null), null);
    }

    @Override
    public void reply(Object message) {
        this.reply(message, null);
    }

    @Override
    public void reply(JsonObject message) {
        this.reply(message, null);
    }

    @Override
    public void reply(JsonArray message) {
        this.reply(message, null);
    }

    @Override
    public void reply(String message) {
        this.reply(message, null);
    }

    @Override
    public void reply(Buffer message) {
        this.reply(message, null);
    }

    @Override
    public void reply(byte[] message) {
        this.reply(message, (Handler)null);
    }

    @Override
    public void reply(Integer message) {
        this.reply(message, null);
    }

    @Override
    public void reply(Long message) {
        this.reply(message, null);
    }

    @Override
    public void reply(Short message) {
        this.reply(message, null);
    }

    @Override
    public void reply(Character message) {
        this.reply(message, null);
    }

    @Override
    public void reply(Boolean message) {
        this.reply(message, null);
    }

    @Override
    public void reply(Float message) {
        this.reply(message, null);
    }

    @Override
    public void reply(Double message) {
        this.reply(message, null);
    }

    @Override
    public <T> void reply(Handler<Message<T>> replyHandler) {
        this.sendReply(DefaultEventBus.createMessage(true, this.replyAddress, null), replyHandler);
    }

    @Override
    public <T> void replyWithTimeout(long timeout, Handler<AsyncResult<Message<T>>> replyHandler) {
        this.sendReplyWithTimeout(DefaultEventBus.createMessage(true, this.replyAddress, null), timeout, replyHandler);
    }

    @Override
    public <T> void reply(Object message, Handler<Message<T>> replyHandler) {
        this.sendReply(DefaultEventBus.createMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void replyWithTimeout(Object message, long timeout, Handler<AsyncResult<Message<T>>> replyHandler) {
        this.sendReplyWithTimeout(DefaultEventBus.createMessage(true, this.replyAddress, message), timeout, replyHandler);
    }

    @Override
    public <T> void reply(JsonObject message, Handler<Message<T>> replyHandler) {
        this.sendReply(new JsonObjectMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void replyWithTimeout(JsonObject message, long timeout, Handler<AsyncResult<Message<T>>> replyHandler) {
        this.sendReplyWithTimeout(new JsonObjectMessage(true, this.replyAddress, message), timeout, replyHandler);
    }

    @Override
    public <T> void reply(JsonArray message, Handler<Message<T>> replyHandler) {
        this.sendReply(new JsonArrayMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void replyWithTimeout(JsonArray message, long timeout, Handler<AsyncResult<Message<T>>> replyHandler) {
        this.sendReplyWithTimeout(new JsonArrayMessage(true, this.replyAddress, message), timeout, replyHandler);
    }

    @Override
    public <T> void reply(String message, Handler<Message<T>> replyHandler) {
        this.sendReply(new StringMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void replyWithTimeout(String message, long timeout, Handler<AsyncResult<Message<T>>> replyHandler) {
        this.sendReplyWithTimeout(new StringMessage(true, this.replyAddress, message), timeout, replyHandler);
    }

    @Override
    public <T> void reply(Buffer message, Handler<Message<T>> replyHandler) {
        this.sendReply(new BufferMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void replyWithTimeout(Buffer message, long timeout, Handler<AsyncResult<Message<T>>> replyHandler) {
        this.sendReplyWithTimeout(new BufferMessage(true, this.replyAddress, message), timeout, replyHandler);
    }

    @Override
    public <T> void reply(byte[] message, Handler<Message<T>> replyHandler) {
        this.sendReply(new ByteArrayMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void replyWithTimeout(byte[] message, long timeout, Handler<AsyncResult<Message<T>>> replyHandler) {
        this.sendReplyWithTimeout(new ByteArrayMessage(true, this.replyAddress, message), timeout, replyHandler);
    }

    @Override
    public <T> void reply(Integer message, Handler<Message<T>> replyHandler) {
        this.sendReply(new IntMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void replyWithTimeout(Integer message, long timeout, Handler<AsyncResult<Message<T>>> replyHandler) {
        this.sendReplyWithTimeout(new IntMessage(true, this.replyAddress, message), timeout, replyHandler);
    }

    @Override
    public <T> void reply(Long message, Handler<Message<T>> replyHandler) {
        this.sendReply(new LongMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void replyWithTimeout(Long message, long timeout, Handler<AsyncResult<Message<T>>> replyHandler) {
        this.sendReplyWithTimeout(new LongMessage(true, this.replyAddress, message), timeout, replyHandler);
    }

    @Override
    public <T> void reply(Short message, Handler<Message<T>> replyHandler) {
        this.sendReply(new ShortMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void replyWithTimeout(Short message, long timeout, Handler<AsyncResult<Message<T>>> replyHandler) {
        this.sendReplyWithTimeout(new ShortMessage(true, this.replyAddress, message), timeout, replyHandler);
    }

    @Override
    public <T> void reply(Character message, Handler<Message<T>> replyHandler) {
        this.sendReply(new CharacterMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void replyWithTimeout(Character message, long timeout, Handler<AsyncResult<Message<T>>> replyHandler) {
        this.sendReplyWithTimeout(new CharacterMessage(true, this.replyAddress, message), timeout, replyHandler);
    }

    @Override
    public <T> void reply(Boolean message, Handler<Message<T>> replyHandler) {
        this.sendReply(new BooleanMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void replyWithTimeout(Boolean message, long timeout, Handler<AsyncResult<Message<T>>> replyHandler) {
        this.sendReplyWithTimeout(new BooleanMessage(true, this.replyAddress, message), timeout, replyHandler);
    }

    @Override
    public <T> void reply(Float message, Handler<Message<T>> replyHandler) {
        this.sendReply(new FloatMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void replyWithTimeout(Float message, long timeout, Handler<AsyncResult<Message<T>>> replyHandler) {
        this.sendReplyWithTimeout(new FloatMessage(true, this.replyAddress, message), timeout, replyHandler);
    }

    @Override
    public <T> void reply(Double message, Handler<Message<T>> replyHandler) {
        this.sendReply(new DoubleMessage(true, this.replyAddress, message), replyHandler);
    }

    @Override
    public <T> void replyWithTimeout(Double message, long timeout, Handler<AsyncResult<Message<T>>> replyHandler) {
        this.sendReplyWithTimeout(new DoubleMessage(true, this.replyAddress, message), timeout, replyHandler);
    }

    @Override
    public void fail(int failureCode, String message) {
        this.sendReply(new ReplyFailureMessage(this.replyAddress, new ReplyException(ReplyFailure.RECIPIENT_FAILURE, failureCode, message)), null);
    }

    protected BaseMessage(Buffer readBuff) {
        int pos = 1;
        byte bsend = readBuff.getByte(pos);
        this.send = bsend == 0;
        int addressLength = readBuff.getInt(++pos);
        byte[] addressBytes = readBuff.getBytes(pos += 4, pos + addressLength);
        this.address = new String(addressBytes, CharsetUtil.UTF_8);
        int port = readBuff.getInt(pos += addressLength);
        int hostLength = readBuff.getInt(pos += 4);
        byte[] hostBytes = readBuff.getBytes(pos += 4, pos + hostLength);
        String host = new String(hostBytes, CharsetUtil.UTF_8);
        this.sender = new ServerID(port, host);
        int replyAddressLength = readBuff.getInt(pos += hostLength);
        pos += 4;
        if (replyAddressLength > 0) {
            byte[] replyAddressBytes = readBuff.getBytes(pos, pos + replyAddressLength);
            pos += replyAddressLength;
            this.replyAddress = new String(replyAddressBytes, CharsetUtil.UTF_8);
        } else {
            this.replyAddress = null;
        }
        this.readBody(pos, readBuff);
    }

    protected void write(NetSocket socket) {
        int length = 6 + this.address.length() + 1 + 4 * this.sender.host.length() + 4 + (this.replyAddress == null ? 0 : this.replyAddress.length()) + this.getBodyLength();
        Buffer totBuff = new Buffer(length);
        totBuff.appendInt(0);
        totBuff.appendByte(this.type());
        totBuff.appendByte(this.send ? (byte)0 : 1);
        this.writeString(totBuff, this.address);
        totBuff.appendInt(this.sender.port);
        this.writeString(totBuff, this.sender.host);
        if (this.replyAddress != null) {
            this.writeString(totBuff, this.replyAddress);
        } else {
            totBuff.appendInt(0);
        }
        this.writeBody(totBuff);
        totBuff.setInt(0, totBuff.length() - 4);
        socket.write(totBuff);
    }

    protected void writeString(Buffer buff, String str) {
        byte[] strBytes = str.getBytes(CharsetUtil.UTF_8);
        buff.appendInt(strBytes.length);
        buff.appendBytes(strBytes);
    }

    protected abstract byte type();

    protected abstract Message<U> copy();

    protected abstract void readBody(int var1, Buffer var2);

    protected abstract void writeBody(Buffer var1);

    protected abstract int getBodyLength();

    private <T> void sendReply(BaseMessage msg, Handler<Message<T>> replyHandler) {
        if (this.bus != null && this.replyAddress != null) {
            this.bus.sendReply(this.sender, msg, replyHandler);
        }
    }

    private <T> void sendReplyWithTimeout(BaseMessage msg, long timeout, Handler<AsyncResult<Message<T>>> replyHandler) {
        if (this.bus != null && this.replyAddress != null) {
            this.bus.sendReplyWithTimeout(this.sender, msg, timeout, replyHandler);
        }
    }
}

