/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.net.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandler;
import java.util.Map;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.net.impl.DefaultNetSocket;
import org.vertx.java.core.net.impl.VertxStateHandler;

public class VertxNetHandler
extends VertxStateHandler<DefaultNetSocket>
implements ChannelInboundByteHandler {
    public VertxNetHandler(VertxInternal vertx, Map<Channel, DefaultNetSocket> connectionMap) {
        super(vertx, connectionMap);
    }

    public ByteBuf newInboundBuffer(ChannelHandlerContext channelHandlerContext) throws Exception {
        return channelHandlerContext.alloc().ioBuffer();
    }

    public void discardInboundReadBytes(ChannelHandlerContext ctx) throws Exception {
        ctx.inboundByteBuffer().clear();
    }

    public void inboundBufferUpdated(ChannelHandlerContext chctx) {
        ByteBuf in = chctx.inboundByteBuffer();
        final DefaultNetSocket sock = (DefaultNetSocket)this.connectionMap.get(chctx.channel());
        if (sock != null) {
            Channel ch = chctx.channel();
            DefaultContext context = this.getContext(sock);
            if (context.isOnCorrectWorker(ch.eventLoop())) {
                try {
                    this.vertx.setContext(context);
                    sock.handleDataReceived(new Buffer(in.slice()));
                }
                catch (Throwable t) {
                    context.reportException(t);
                }
            } else {
                final ByteBuf buf = in.readBytes(in.readableBytes());
                context.execute(new Runnable(){

                    @Override
                    public void run() {
                        sock.handleDataReceived(new Buffer(buf));
                    }
                });
            }
        }
    }
}

