/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.eventbus.impl;

import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.eventbus.impl.BaseMessage;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

class DoubleMessage
extends BaseMessage<Double> {
    private static final Logger log = LoggerFactory.getLogger(DoubleMessage.class);

    DoubleMessage(boolean send, String address, Double body) {
        super(send, address, body);
    }

    public DoubleMessage(Buffer readBuff) {
        super(readBuff);
    }

    @Override
    protected void readBody(int pos, Buffer readBuff) {
        boolean isNull;
        boolean bl = isNull = readBuff.getByte(pos) == 0;
        if (!isNull) {
            this.body = readBuff.getDouble(++pos);
        }
    }

    @Override
    protected void writeBody(Buffer buff) {
        if (this.body == null) {
            buff.appendByte((byte)0);
        } else {
            buff.appendByte((byte)1);
            buff.appendDouble((Double)this.body);
        }
    }

    @Override
    protected int getBodyLength() {
        return 1 + (this.body == null ? 0 : 8);
    }

    @Override
    protected Message<Double> copy() {
        return this;
    }

    @Override
    protected byte type() {
        return 6;
    }
}

