/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.impl;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Context;
import org.vertx.java.core.Handler;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.eventbus.impl.DefaultEventBus;
import org.vertx.java.core.eventbus.impl.hazelcast.HazelcastClusterManager;
import org.vertx.java.core.file.FileSystem;
import org.vertx.java.core.file.impl.DefaultFileSystem;
import org.vertx.java.core.file.impl.WindowsFileSystem;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.http.HttpServer;
import org.vertx.java.core.http.impl.DefaultHttpClient;
import org.vertx.java.core.http.impl.DefaultHttpServer;
import org.vertx.java.core.impl.Closeable;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.impl.EventLoopContext;
import org.vertx.java.core.impl.MultiThreadedWorkerContext;
import org.vertx.java.core.impl.OrderedExecutorFactory;
import org.vertx.java.core.impl.VertxExecutorFactory;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.impl.Windows;
import org.vertx.java.core.impl.WorkerContext;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.net.NetClient;
import org.vertx.java.core.net.NetServer;
import org.vertx.java.core.net.impl.DefaultNetClient;
import org.vertx.java.core.net.impl.DefaultNetServer;
import org.vertx.java.core.net.impl.ServerID;
import org.vertx.java.core.shareddata.SharedData;
import org.vertx.java.core.sockjs.SockJSServer;
import org.vertx.java.core.sockjs.impl.DefaultSockJSServer;

public class DefaultVertx
implements VertxInternal {
    private static final Logger log = LoggerFactory.getLogger(DefaultVertx.class);
    private final FileSystem fileSystem = this.getFileSystem();
    private final EventBus eventBus;
    private final SharedData sharedData = new SharedData();
    private ExecutorService backgroundPool = VertxExecutorFactory.workerPool("vert.x-worker-thread-");
    private final OrderedExecutorFactory orderedFact = new OrderedExecutorFactory(this.backgroundPool);
    private EventLoopGroup eventLoopGroup = VertxExecutorFactory.eventLoopGroup("vert.x-eventloop-thread-");
    private Map<ServerID, DefaultHttpServer> sharedHttpServers = new HashMap<ServerID, DefaultHttpServer>();
    private Map<ServerID, DefaultNetServer> sharedNetServers = new HashMap<ServerID, DefaultNetServer>();
    private final ThreadLocal<DefaultContext> contextTL = new ThreadLocal();
    private final ConcurrentMap<Long, InternalTimerHandler> timeouts = new ConcurrentHashMap<Long, InternalTimerHandler>();
    private final AtomicLong timeoutCounter = new AtomicLong(0L);

    public DefaultVertx() {
        this.eventBus = new DefaultEventBus(this);
    }

    public DefaultVertx(String hostname) {
        this(0, hostname);
    }

    public DefaultVertx(int port, String hostname) {
        this.eventBus = new DefaultEventBus(this, port, hostname, new HazelcastClusterManager(this));
    }

    protected FileSystem getFileSystem() {
        return Windows.isWindows() ? new WindowsFileSystem(this) : new DefaultFileSystem(this);
    }

    @Override
    public NetServer createNetServer() {
        return new DefaultNetServer(this);
    }

    @Override
    public NetClient createNetClient() {
        return new DefaultNetClient(this);
    }

    @Override
    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    @Override
    public SharedData sharedData() {
        return this.sharedData;
    }

    @Override
    public HttpServer createHttpServer() {
        return new DefaultHttpServer(this);
    }

    @Override
    public HttpClient createHttpClient() {
        return new DefaultHttpClient(this);
    }

    @Override
    public SockJSServer createSockJSServer(HttpServer httpServer) {
        return new DefaultSockJSServer(this, httpServer);
    }

    @Override
    public EventBus eventBus() {
        return this.eventBus;
    }

    @Override
    public DefaultContext startOnEventLoop(Runnable runnable) {
        EventLoopContext context = this.createEventLoopContext();
        ((DefaultContext)context).execute(runnable);
        return context;
    }

    @Override
    public DefaultContext startInBackground(Runnable runnable, boolean multiThreaded) {
        DefaultContext context = this.createWorkerContext(multiThreaded);
        context.execute(runnable);
        return context;
    }

    @Override
    public boolean isEventLoop() {
        DefaultContext context = this.getContext();
        if (context != null) {
            return context instanceof EventLoopContext;
        }
        return false;
    }

    @Override
    public boolean isWorker() {
        DefaultContext context = this.getContext();
        if (context != null) {
            return context instanceof WorkerContext;
        }
        return false;
    }

    @Override
    public long setPeriodic(long delay, Handler<Long> handler) {
        return this.scheduleTimeout(this.getOrCreateContext(), handler, delay, true);
    }

    @Override
    public long setTimer(long delay, Handler<Long> handler) {
        return this.scheduleTimeout(this.getOrCreateContext(), handler, delay, false);
    }

    @Override
    public void runOnContext(Handler<Void> task) {
        DefaultContext context = this.getOrCreateContext();
        context.runOnContext(task);
    }

    @Override
    public Context currentContext() {
        return this.getContext();
    }

    @Override
    public ExecutorService getBackgroundPool() {
        return this.backgroundPool;
    }

    @Override
    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public DefaultContext getOrCreateContext() {
        DefaultContext ctx = this.getContext();
        if (ctx == null) {
            ctx = this.createEventLoopContext();
        }
        return ctx;
    }

    @Override
    public void reportException(Throwable t) {
        DefaultContext ctx = this.getContext();
        if (ctx != null) {
            ctx.reportException(t);
        } else {
            log.error("default vertx Unhandled exception ", t);
        }
    }

    @Override
    public Map<ServerID, DefaultHttpServer> sharedHttpServers() {
        return this.sharedHttpServers;
    }

    @Override
    public Map<ServerID, DefaultNetServer> sharedNetServers() {
        return this.sharedNetServers;
    }

    @Override
    public boolean cancelTimer(long id) {
        InternalTimerHandler handler = (InternalTimerHandler)this.timeouts.remove(id);
        if (handler != null) {
            handler.context.removeCloseHook(handler);
            return handler.cancel();
        }
        return false;
    }

    @Override
    public EventLoopContext createEventLoopContext() {
        return new EventLoopContext(this, this.orderedFact.getExecutor());
    }

    private long scheduleTimeout(final DefaultContext context, Handler<Long> handler, long delay, boolean periodic) {
        if (delay < 1L) {
            throw new IllegalArgumentException("Cannot schedule a timer with delay < 1 ms");
        }
        long timerId = this.timeoutCounter.getAndIncrement();
        InternalTimerHandler task = new InternalTimerHandler(timerId, handler, periodic, context);
        final Runnable wrapped = context.wrapTask(task);
        EventLoop el = context.getEventLoop();
        Runnable toRun = context instanceof EventLoopContext ? wrapped : new Runnable(){

            @Override
            public void run() {
                context.execute(wrapped);
            }
        };
        ScheduledFuture future = periodic ? el.scheduleAtFixedRate(toRun, delay, delay, TimeUnit.MILLISECONDS) : el.schedule(toRun, delay, TimeUnit.MILLISECONDS);
        task.future = future;
        this.timeouts.put(timerId, task);
        context.addCloseHook(task);
        return timerId;
    }

    private DefaultContext createWorkerContext(boolean multiThreaded) {
        if (multiThreaded) {
            return new MultiThreadedWorkerContext(this, this.orderedFact.getExecutor(), this.backgroundPool);
        }
        return new WorkerContext(this, this.orderedFact.getExecutor());
    }

    @Override
    public void setContext(DefaultContext context) {
        this.contextTL.set(context);
        if (context != null) {
            context.setTCCL();
        }
    }

    @Override
    public DefaultContext getContext() {
        return this.contextTL.get();
    }

    @Override
    public void stop() {
        if (this.sharedHttpServers != null) {
            for (HttpServer httpServer : this.sharedHttpServers.values()) {
                httpServer.close();
            }
            this.sharedHttpServers = null;
        }
        if (this.sharedNetServers != null) {
            for (NetServer netServer : this.sharedNetServers.values()) {
                netServer.close();
            }
            this.sharedNetServers = null;
        }
        if (this.backgroundPool != null) {
            this.backgroundPool.shutdown();
        }
        try {
            if (this.backgroundPool != null) {
                this.backgroundPool.awaitTermination(20L, TimeUnit.SECONDS);
                this.backgroundPool = null;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.eventLoopGroup != null) {
            this.eventLoopGroup.shutdownGracefully();
            this.eventLoopGroup = null;
        }
        this.setContext(null);
    }

    private class InternalTimerHandler
    implements Runnable,
    Closeable {
        final Handler<Long> handler;
        final boolean periodic;
        final long timerID;
        final DefaultContext context;
        volatile Future<?> future;
        boolean cancelled;

        boolean cancel() {
            this.cancelled = true;
            return this.future.cancel(false);
        }

        InternalTimerHandler(long timerID, Handler<Long> runnable, boolean periodic, DefaultContext context) {
            this.context = context;
            this.timerID = timerID;
            this.handler = runnable;
            this.periodic = periodic;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!this.cancelled) {
                try {
                    this.handler.handle(this.timerID);
                }
                finally {
                    if (!this.periodic) {
                        this.cleanupNonPeriodic();
                    }
                }
            }
        }

        private void cleanupNonPeriodic() {
            DefaultVertx.this.timeouts.remove(this.timerID);
            DefaultContext context = DefaultVertx.this.getContext();
            context.removeCloseHook(this);
        }

        @Override
        public void close(Handler<AsyncResult<Void>> doneHandler) {
            DefaultVertx.this.timeouts.remove(this.timerID);
            this.cancel();
            doneHandler.handle(new DefaultFutureResult<Void>((Void)null));
        }
    }
}

