/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.impl;

import io.netty.channel.EventLoop;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.Context;
import org.vertx.java.core.Handler;
import org.vertx.java.core.impl.Closeable;
import org.vertx.java.core.impl.CountingCompletionHandler;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.impl.DeploymentHandle;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public abstract class DefaultContext
implements Context {
    private static final Logger log = LoggerFactory.getLogger(DefaultContext.class);
    protected final VertxInternal vertx;
    private DeploymentHandle deploymentContext;
    private Path pathAdjustment;
    private Set<Closeable> closeHooks;
    private final ClassLoader tccl;
    private boolean closed;
    private final EventLoop eventLoop;
    protected final Executor orderedBgExec;

    protected DefaultContext(VertxInternal vertx, Executor orderedBgExec) {
        this.vertx = vertx;
        this.orderedBgExec = orderedBgExec;
        this.eventLoop = vertx.getEventLoopGroup().next();
        this.tccl = Thread.currentThread().getContextClassLoader();
    }

    public void setTCCL() {
        Thread.currentThread().setContextClassLoader(this.tccl);
    }

    public void setDeploymentHandle(DeploymentHandle deploymentHandle) {
        this.deploymentContext = deploymentHandle;
    }

    public DeploymentHandle getDeploymentHandle() {
        return this.deploymentContext;
    }

    public Path getPathAdjustment() {
        return this.pathAdjustment;
    }

    public void setPathAdjustment(Path pathAdjustment) {
        this.pathAdjustment = pathAdjustment;
    }

    public void reportException(Throwable t) {
        if (this.deploymentContext != null) {
            this.deploymentContext.reportException(t);
        } else {
            log.error("Unhandled exception", t);
        }
    }

    public void addCloseHook(Closeable hook) {
        if (this.closeHooks == null) {
            this.closeHooks = new HashSet<Closeable>();
        }
        this.closeHooks.add(hook);
    }

    public void removeCloseHook(Closeable hook) {
        if (this.closeHooks != null) {
            this.closeHooks.remove(hook);
        }
    }

    public void runCloseHooks(Handler<AsyncResult<Void>> doneHandler) {
        if (this.closeHooks != null) {
            final CountingCompletionHandler aggHandler = new CountingCompletionHandler(this.vertx, this.closeHooks.size());
            aggHandler.setHandler(doneHandler);
            for (Closeable hook : new HashSet<Closeable>(this.closeHooks)) {
                try {
                    hook.close((Handler<AsyncResult<Void>>)new AsyncResultHandler<Void>(){

                        @Override
                        public void handle(AsyncResult<Void> asyncResult) {
                            if (asyncResult.failed()) {
                                aggHandler.failed(asyncResult.cause());
                            } else {
                                aggHandler.complete();
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    this.reportException(t);
                }
            }
        } else {
            doneHandler.handle(new DefaultFutureResult<Void>((Void)null));
        }
    }

    public abstract void execute(Runnable var1);

    public abstract boolean isOnCorrectWorker(EventLoop var1);

    public void execute(EventLoop worker, Runnable handler) {
        if (this.isOnCorrectWorker(worker)) {
            this.wrapTask(handler).run();
        } else {
            this.execute(handler);
        }
    }

    @Override
    public void runOnContext(final Handler<Void> task) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                task.handle(null);
            }
        });
    }

    public EventLoop getEventLoop() {
        return this.eventLoop;
    }

    protected void executeOnOrderedWorkerExec(Runnable task) {
        this.orderedBgExec.execute(this.wrapTask(task));
    }

    public void close() {
        this.unsetContext();
        this.closed = true;
    }

    private void unsetContext() {
        this.vertx.setContext(null);
        Thread.currentThread().setContextClassLoader(null);
    }

    protected Runnable wrapTask(final Runnable task) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread currentThread = Thread.currentThread();
                String threadName = currentThread.getName();
                try {
                    DefaultContext.this.vertx.setContext(DefaultContext.this);
                    DefaultContext.this.startExecute();
                    task.run();
                }
                catch (Throwable t) {
                    DefaultContext.this.reportException(t);
                }
                finally {
                    DefaultContext.this.endExecute();
                    if (!threadName.equals(currentThread.getName())) {
                        currentThread.setName(threadName);
                    }
                }
                if (DefaultContext.this.closed) {
                    DefaultContext.this.unsetContext();
                }
            }
        };
    }

    public void startExecute() {
    }

    public void endExecute() {
    }
}

