/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.type;

import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.DataObjectAnnotatedInfo;
import io.vertx.codegen.type.JsonCodecInfo;
import io.vertx.codegen.type.TypeInfo;
import java.util.List;
import java.util.function.Function;

public class DataObjectTypeInfo
extends ClassTypeInfo {
    private final JsonCodecInfo jsonCodecInfo;
    private final DataObjectAnnotatedInfo dataObjectAnnotatedInfo;
    private final TypeInfo targetJsonType;

    public DataObjectTypeInfo(String name, ModuleInfo module, boolean nullable, List<TypeParamInfo.Class> params, JsonCodecInfo jsonCodecInfo, TypeInfo targetJsonType) {
        super(ClassKind.DATA_OBJECT, name, module, nullable, params);
        this.jsonCodecInfo = jsonCodecInfo;
        this.dataObjectAnnotatedInfo = null;
        this.targetJsonType = targetJsonType;
    }

    public DataObjectTypeInfo(String name, ModuleInfo module, boolean nullable, List<TypeParamInfo.Class> params, DataObjectAnnotatedInfo dataObjectAnnotatedInfo, TypeInfo targetJsonType) {
        super(ClassKind.DATA_OBJECT, name, module, nullable, params);
        this.jsonCodecInfo = null;
        this.dataObjectAnnotatedInfo = dataObjectAnnotatedInfo;
        this.targetJsonType = targetJsonType;
    }

    public TypeInfo getTargetJsonType() {
        return this.targetJsonType;
    }

    public boolean hasJsonCodec() {
        return this.jsonCodecInfo != null;
    }

    public boolean isDataObjectAnnotatedType() {
        return this.dataObjectAnnotatedInfo != null;
    }

    public JsonCodecInfo getJsonCodecInfo() {
        return this.jsonCodecInfo;
    }

    public DataObjectAnnotatedInfo getDataObjectAnnotatedInfo() {
        return this.dataObjectAnnotatedInfo;
    }

    public <T> T match(Function<JsonCodecInfo, T> hasJsonCodec, Function<DataObjectAnnotatedInfo, T> isDataObjectAnnotated) {
        return this.hasJsonCodec() ? hasJsonCodec.apply(this.jsonCodecInfo) : isDataObjectAnnotated.apply(this.dataObjectAnnotatedInfo);
    }

    public boolean isEncodable() {
        return this.match(jsonCodecInfo -> jsonCodecInfo.getJsonEncoderSimpleName() != null, DataObjectAnnotatedInfo::isEncodable);
    }

    public boolean isDecodable() {
        return this.match(jsonCodecInfo -> jsonCodecInfo.getJsonDecoderSimpleName() != null, DataObjectAnnotatedInfo::isDecodable);
    }
}

