/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.type;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum ClassKind {
    STRING(true, false, false),
    BOXED_PRIMITIVE(true, false, false),
    PRIMITIVE(true, false, false),
    ENUM(false, false, false),
    JSON_OBJECT(false, true, false),
    JSON_ARRAY(false, true, false),
    THROWABLE(false, false, false),
    VOID(false, false, false),
    OBJECT(false, false, false),
    LIST(false, false, true),
    SET(false, false, true),
    MAP(false, false, true),
    API(false, false, false),
    DATA_OBJECT(false, false, false),
    HANDLER(false, false, false),
    ASYNC_RESULT(false, false, false),
    OTHER(false, false, false);

    public final boolean basic;
    public final boolean json;
    public final boolean collection;

    private ClassKind(boolean basic, boolean json, boolean collection) {
        this.basic = basic;
        this.json = json;
        this.collection = collection;
    }

    public static Map<String, ClassKind> vars() {
        HashMap<String, ClassKind> vars = new HashMap<String, ClassKind>();
        for (ClassKind classKind : ClassKind.values()) {
            vars.put("CLASS_" + classKind.name(), classKind);
        }
        return vars;
    }

    public static ClassKind getKind(String fqcn, boolean isDataObjectAnnotated, boolean isVertxGenAnnotated) {
        if (isDataObjectAnnotated) {
            return DATA_OBJECT;
        }
        if (isVertxGenAnnotated) {
            return API;
        }
        if (fqcn.equals("io.vertx.core.Handler")) {
            return HANDLER;
        }
        if (fqcn.equals("io.vertx.core.AsyncResult")) {
            return ASYNC_RESULT;
        }
        if (fqcn.equals("io.vertx.core.json.JsonArray")) {
            return JSON_ARRAY;
        }
        if (fqcn.equals("io.vertx.core.json.JsonObject")) {
            return JSON_OBJECT;
        }
        if (fqcn.equals(Object.class.getName())) {
            return OBJECT;
        }
        if (fqcn.equals(String.class.getName())) {
            return STRING;
        }
        if (fqcn.equals(List.class.getName())) {
            return LIST;
        }
        if (fqcn.equals(Set.class.getName())) {
            return SET;
        }
        if (fqcn.equals(Map.class.getName())) {
            return MAP;
        }
        if (fqcn.equals(Throwable.class.getName())) {
            return THROWABLE;
        }
        if (fqcn.equals(Void.class.getName())) {
            return VOID;
        }
        if (fqcn.equals(Integer.class.getName()) || fqcn.equals(Long.class.getName()) || fqcn.equals(Boolean.class.getName()) || fqcn.equals(Double.class.getName()) || fqcn.equals(Float.class.getName()) || fqcn.equals(Short.class.getName()) || fqcn.equals(Character.class.getName()) || fqcn.equals(Byte.class.getName())) {
            return BOXED_PRIMITIVE;
        }
        return OTHER;
    }
}

