/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.overloadcheck;

import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.overloadcheck.SimpleMethod;
import io.vertx.codegen.overloadcheck.SimpleParam;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class MethodOverloadChecker {
    private final Map<String, Map<String, String>> typeMappingsMap = new HashMap<String, Map<String, String>>();
    private static final String ALL_TYPE = "ALL";

    public MethodOverloadChecker() {
        this.loadTypeMappings();
    }

    public void checkAmbiguous(List<MethodInfo> meths) {
        this.checkAmbiguousSimple(this.convert(meths));
    }

    public void checkAmbiguousSimple(List<SimpleMethod> meths) {
        ArrayList<SimpleMethod> methods = new ArrayList<SimpleMethod>(meths);
        HashMap<Integer, ArrayList<SimpleMethod>> byNumParams = new HashMap<Integer, ArrayList<SimpleMethod>>();
        for (SimpleMethod simpleMethod : methods) {
            int numParams = simpleMethod.params.size();
            ArrayList<SimpleMethod> list = (ArrayList<SimpleMethod>)byNumParams.get(numParams);
            if (list == null) {
                list = new ArrayList<SimpleMethod>();
                byNumParams.put(numParams, list);
            }
            list.add(simpleMethod);
        }
        for (Map.Entry entry : byNumParams.entrySet()) {
            List list = (List)entry.getValue();
            if (list.size() == 1) continue;
            for (Map.Entry<String, Map<String, String>> mappingEntry : this.typeMappingsMap.entrySet()) {
                this.checkMethodList(mappingEntry.getKey(), list, mappingEntry.getValue());
            }
        }
    }

    private List<SimpleMethod> convert(List<MethodInfo> meths) {
        ArrayList<SimpleMethod> simpleMethods = new ArrayList<SimpleMethod>(meths.size());
        for (MethodInfo meth : meths) {
            ArrayList<SimpleParam> simpleParams = new ArrayList<SimpleParam>();
            for (ParamInfo param : meth.getParams()) {
                simpleParams.add(new SimpleParam(param.getName(), param.getType().getKind(), param.getType().getName()));
            }
            simpleMethods.add(new SimpleMethod(meth.getName(), simpleParams));
        }
        return simpleMethods;
    }

    private void checkMethodList(String targetLang, List<SimpleMethod> meths, Map<String, String> typeMapping) {
        ArrayList<List> paramsTypesList = new ArrayList<List>();
        for (SimpleMethod meth : meths) {
            List paramTypes = this.convertToLangParamTypes(meth, typeMapping);
            paramsTypesList.add(paramTypes);
        }
        int index1 = 0;
        for (List paramTypes : paramsTypesList) {
            int index2 = 0;
            for (List paramTypesToCompare : paramsTypesList) {
                if (index1 != index2) {
                    boolean matched = true;
                    for (int i = 0; i < paramTypes.size(); ++i) {
                        String paramTypeToCompare;
                        String paramType = (String)paramTypes.get(i);
                        if (paramType.equals(paramTypeToCompare = (String)paramTypesToCompare.get(i)) || paramType.equals(ALL_TYPE) || paramTypeToCompare.equals(ALL_TYPE)) continue;
                        matched = false;
                        break;
                    }
                    if (matched) {
                        SimpleMethod clashing1 = meths.get(index1);
                        SimpleMethod clashing2 = meths.get(index2);
                        String msg = "Failed to generate because it would be impossible in target language " + targetLang + " at runtime to resolve which of the following overloaded methods to call in the Java API: " + clashing1 + " and " + clashing2;
                        throw new IllegalArgumentException(msg);
                    }
                }
                ++index2;
            }
            ++index1;
        }
    }

    private List<String> convertToLangParamTypes(SimpleMethod meth, Map<String, String> typeMapping) {
        ArrayList<String> langParamTypes = new ArrayList<String>();
        for (SimpleParam param : meth.params) {
            String lhs;
            String langType = typeMapping.get(param.classKind.toString());
            if (langType == null && (langType = typeMapping.get(lhs = param.classKind.toString() + "." + param.typeName)) == null) {
                throw new IllegalStateException("No type mapping found for param type " + lhs);
            }
            langParamTypes.add(langType);
        }
        return langParamTypes;
    }

    private void loadTypeMappings() {
        try (InputStream is = MethodOverloadChecker.class.getClassLoader().getResourceAsStream("lang-type-mapping.properties");){
            Properties props = new Properties();
            props.load(is);
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String lhs = (String)entry.getKey();
                String rhs = (String)entry.getValue();
                int pos = lhs.indexOf(46);
                String lang = lhs.substring(0, pos);
                String key = lhs.substring(pos + 1);
                Map<String, String> typeMapping = this.typeMappingsMap.get(lang);
                if (typeMapping == null) {
                    typeMapping = new HashMap<String, String>();
                    this.typeMappingsMap.put(lang, typeMapping);
                }
                typeMapping.put(key, rhs);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

