/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.Case;
import io.vertx.codegen.annotations.GenModule;
import javax.lang.model.element.PackageElement;
import javax.lang.model.util.Elements;

public class ModuleInfo {
    private final String packageName;
    private final String name;
    private final String groupPackageName;

    public ModuleInfo(String packageName, String name, String groupPackageName) {
        this.packageName = packageName;
        this.name = name;
        this.groupPackageName = groupPackageName;
    }

    public static ModuleInfo resolve(Elements elementUtils, PackageElement pkgElt) {
        while (pkgElt != null) {
            GenModule annotation = pkgElt.getAnnotation(GenModule.class);
            if (annotation != null) {
                return new ModuleInfo(pkgElt.getQualifiedName().toString(), annotation.name(), annotation.groupPackageName());
            }
            String pkgQN = pkgElt.getQualifiedName().toString();
            int pos = pkgQN.lastIndexOf(46);
            if (pos == -1) break;
            pkgElt = elementUtils.getPackageElement(pkgQN.substring(0, pos));
        }
        return null;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String translatePackageName(String lang) {
        return this.translateQualifiedName(this.packageName, lang);
    }

    public String translateQualifiedName(String qualifiedName, String lang) {
        if (qualifiedName.startsWith(this.groupPackageName)) {
            return this.groupPackageName + "." + lang + qualifiedName.substring(this.groupPackageName.length(), qualifiedName.length());
        }
        return qualifiedName;
    }

    public String getName() {
        return this.name;
    }

    public String getName(Case _case) {
        return _case.format(Case.KEBAB.parse(this.name));
    }
}

