/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn4j;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.webauthn4j.WebAuthn4JCredentialsConverter;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class WebAuthn4JCredentials
implements Credentials {
    private String challenge;
    private JsonObject webauthn;
    private String username;
    private String origin;
    private String domain;

    public WebAuthn4JCredentials() {
    }

    public WebAuthn4JCredentials(JsonObject json) {
        WebAuthn4JCredentialsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public String getChallenge() {
        return this.challenge;
    }

    public WebAuthn4JCredentials setChallenge(String challenge) {
        this.challenge = challenge;
        return this;
    }

    public JsonObject getWebauthn() {
        return this.webauthn;
    }

    public WebAuthn4JCredentials setWebauthn(JsonObject webauthn) {
        this.webauthn = webauthn;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public WebAuthn4JCredentials setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getOrigin() {
        return this.origin;
    }

    public WebAuthn4JCredentials setOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public WebAuthn4JCredentials setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public <V> void checkValid(V arg) throws CredentialValidationException {
        if (this.challenge == null || this.challenge.length() == 0) {
            throw new CredentialValidationException("Challenge cannot be null or empty");
        }
        if (this.webauthn == null) {
            throw new CredentialValidationException("webauthn cannot be null");
        }
        if (!(this.webauthn.containsKey("id") && this.webauthn.containsKey("rawId") && this.webauthn.containsKey("response"))) {
            throw new CredentialValidationException("Invalid webauthn JSON, missing one of {id, rawId, response}");
        }
        if (!this.webauthn.getString("id").equals(this.webauthn.getString("rawId"))) {
            throw new CredentialValidationException("Invalid webauthn {id} not base64url encoded");
        }
        try {
            JsonObject response = this.webauthn.getJsonObject("response");
            if (!response.containsKey("clientDataJSON")) {
                throw new CredentialValidationException("Missing webauthn.response.clientDataJSON");
            }
            if (response.containsKey("userHandle") && !(response.getValue("userHandle") instanceof String)) {
                throw new CredentialValidationException("webauthn.response.userHandle must be String");
            }
        }
        catch (ClassCastException e) {
            throw new CredentialValidationException("webauthn.response must be JSON");
        }
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        WebAuthn4JCredentialsConverter.toJson(this, json);
        return json;
    }
}

