/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.sqlclient.impl;

import io.vertx.core.Future;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.PermissionBasedAuthorization;
import io.vertx.ext.auth.authorization.RoleBasedAuthorization;
import io.vertx.ext.auth.sqlclient.SqlAuthorization;
import io.vertx.ext.auth.sqlclient.SqlAuthorizationOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.Tuple;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class SqlAuthorizationImpl
implements SqlAuthorization {
    private final SqlAuthorizationOptions options;
    private final SqlClient client;

    public SqlAuthorizationImpl(SqlClient client, SqlAuthorizationOptions options) {
        this.client = Objects.requireNonNull(client);
        this.options = Objects.requireNonNull(options);
    }

    public String getId() {
        return "sql-client";
    }

    private Future<Set<Authorization>> getRoles(String username) {
        if (this.options.getRolesQuery() != null) {
            return this.client.preparedQuery(this.options.getRolesQuery()).execute(Tuple.of((Object)username)).compose(rows -> {
                HashSet<RoleBasedAuthorization> authorizations = new HashSet<RoleBasedAuthorization>();
                for (Row row : rows) {
                    String role = row.getString(0);
                    authorizations.add(RoleBasedAuthorization.create((String)role));
                }
                return Future.succeededFuture(authorizations);
            });
        }
        return Future.succeededFuture(Collections.emptySet());
    }

    private Future<Set<Authorization>> getPermissions(String username) {
        if (this.options.getPermissionsQuery() != null) {
            return this.client.preparedQuery(this.options.getPermissionsQuery()).execute(Tuple.of((Object)username)).compose(rows -> {
                HashSet<PermissionBasedAuthorization> authorizations = new HashSet<PermissionBasedAuthorization>();
                for (Row row : rows) {
                    String permission = row.getString(0);
                    authorizations.add(PermissionBasedAuthorization.create((String)permission));
                }
                return Future.succeededFuture(authorizations);
            });
        }
        return Future.succeededFuture(Collections.emptySet());
    }

    public Future<Void> getAuthorizations(User user) {
        String username = user.principal().getString("username");
        if (username != null) {
            return this.getRoles(username).compose(roles -> {
                HashSet authorizations = new HashSet(roles);
                return this.getPermissions(username).onSuccess(permissions -> {
                    authorizations.addAll(permissions);
                    user.authorizations().put(this.getId(), authorizations);
                }).mapEmpty();
            });
        }
        return Future.failedFuture((String)"Couldn't get the username from the principal");
    }
}

