/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.auth.HashingStrategy;
import io.vertx.ext.auth.sqlclient.SqlUserUtil;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.Tuple;
import java.security.SecureRandom;
import java.util.Base64;

public class SqlUserUtilImpl
implements SqlUserUtil {
    private static final String INSERT_USER = "INSERT INTO user (username, password) VALUES (?, ?)";
    private static final String INSERT_USER_ROLE = "INSERT INTO user_roles (username, role) VALUES (?, ?)";
    private static final String INSERT_ROLE_PERMISSION = "INSERT INTO roles_perms (role, permission) VALUES (?, ?)";
    private final SqlClient client;
    private final HashingStrategy strategy = HashingStrategy.load();
    private final SecureRandom random = new SecureRandom();
    private final String insertUser;
    private final String insertUserRole;
    private final String insertRolePermission;

    public SqlUserUtilImpl(SqlClient client) {
        this(client, INSERT_USER, INSERT_USER_ROLE, INSERT_ROLE_PERMISSION);
    }

    public SqlUserUtilImpl(SqlClient client, String insertUser, String insertUserRole, String insertRolePermission) {
        this.client = client;
        this.insertUser = insertUser;
        this.insertUserRole = insertUserRole;
        this.insertRolePermission = insertRolePermission;
    }

    @Override
    public SqlUserUtil createUser(String username, String password, Handler<AsyncResult<Void>> resultHandler) {
        if (username == null || password == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"username or password are null"));
            return this;
        }
        byte[] salt = new byte[32];
        this.random.nextBytes(salt);
        return this.createHashedUser(username, this.strategy.hash("pbkdf2", null, Base64.getMimeEncoder().encodeToString(salt), password), resultHandler);
    }

    @Override
    public SqlUserUtil createHashedUser(String username, String hash, Handler<AsyncResult<Void>> resultHandler) {
        if (username == null || hash == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"username or password hash are null"));
            return this;
        }
        this.client.preparedQuery(this.insertUser).execute(Tuple.of((Object)username, (Object)hash), prepare -> {
            if (prepare.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture());
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)prepare.cause()));
            }
        });
        return this;
    }

    @Override
    public SqlUserUtil createUserRole(String username, String role, Handler<AsyncResult<Void>> resultHandler) {
        if (username == null || role == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"username or role are null"));
            return this;
        }
        this.client.preparedQuery(this.insertUserRole).execute(Tuple.of((Object)username, (Object)role), prepare -> {
            if (prepare.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture());
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)prepare.cause()));
            }
        });
        return this;
    }

    @Override
    public SqlUserUtil createRolePermission(String role, String permission, Handler<AsyncResult<Void>> resultHandler) {
        if (role == null || permission == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"role or permission are null"));
            return this;
        }
        this.client.preparedQuery(this.insertRolePermission).execute(Tuple.of((Object)role, (Object)permission), insert -> {
            if (insert.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture());
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)insert.cause()));
            }
        });
        return this;
    }
}

