/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.properties.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationProvider;
import io.vertx.ext.auth.authorization.RoleBasedAuthorization;
import io.vertx.ext.auth.authorization.WildcardPermissionBasedAuthorization;
import io.vertx.ext.auth.impl.UserImpl;
import io.vertx.ext.auth.properties.PropertyFileAuthentication;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertyFileAuthenticationImpl
implements PropertyFileAuthentication,
AuthorizationProvider {
    private static final Logger logger = Logger.getLogger(PropertyFileAuthentication.class.getName());
    private Vertx vertx;
    private String path;
    private Map<String, User> users;
    private Map<String, Role> roles;

    public PropertyFileAuthenticationImpl(Vertx vertx, String path) {
        this.vertx = Objects.requireNonNull(vertx);
        this.path = Objects.requireNonNull(path);
    }

    private void readFile(Handler<AsyncResult<Boolean>> handler) {
        this.vertx.fileSystem().readFile(this.path, readResponse -> {
            this.users = new HashMap<String, User>();
            this.roles = new HashMap<String, Role>();
            if (readResponse.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)readResponse.cause()));
            } else {
                String[] lines;
                String fileContent = ((Buffer)readResponse.result()).toString(StandardCharsets.UTF_8);
                for (String line : lines = fileContent.split("\n")) {
                    String tmpName;
                    int index;
                    if (line.startsWith("user.")) {
                        String tmpRoles;
                        logger.log(Level.FINE, () -> "read user line: " + line);
                        String usernameAndRoles = line.substring(5);
                        index = usernameAndRoles.indexOf(61);
                        tmpName = index > 0 ? usernameAndRoles.substring(0, index).trim() : "";
                        String string = tmpRoles = index > 0 ? usernameAndRoles.substring(index + 1).trim() : "";
                        if (tmpName.length() > 0) {
                            User user = new User(tmpName);
                            this.users.put(tmpName, user);
                            int roleIndex = 0;
                            String[] stringArray = tmpRoles.split(",");
                            int n = stringArray.length;
                            for (int i = 0; i < n; ++i) {
                                String tmpRole = stringArray[i];
                                tmpRole = tmpRole.trim();
                                if (roleIndex == 0) {
                                    user.password = tmpRole;
                                } else if (tmpRole.length() > 0) {
                                    Role role = this.roles.get(tmpRole);
                                    if (role == null) {
                                        role = new Role(tmpRole);
                                        this.roles.put(tmpRole, role);
                                    }
                                    user.addRole(role);
                                }
                                ++roleIndex;
                            }
                            continue;
                        }
                        logger.log(Level.WARNING, () -> "read blank username - " + line);
                        continue;
                    }
                    if (line.startsWith("role.")) {
                        String tmpProperties;
                        logger.log(Level.FINE, () -> "read role line - " + line);
                        String roleAndProperties = line.substring(5);
                        index = roleAndProperties.indexOf(61);
                        tmpName = index > 0 ? roleAndProperties.substring(0, index).trim() : "";
                        String string = tmpProperties = index > 0 ? roleAndProperties.substring(index + 1).trim() : "";
                        if (tmpName.length() > 0) {
                            Role role = this.roles.get(tmpName);
                            if (role == null) {
                                role = new Role(tmpName);
                                this.roles.put(tmpName, role);
                            }
                            for (String tmpProperty : tmpProperties.split(",")) {
                                if ((tmpProperty = tmpProperty.trim()).length() <= 0) continue;
                                role.addPermission(tmpProperty);
                            }
                            continue;
                        }
                        logger.log(Level.WARNING, () -> "read blank role - " + line);
                        continue;
                    }
                    logger.log(Level.WARNING, () -> "read unknow line - " + line);
                }
                handler.handle((Object)Future.succeededFuture((Object)Boolean.TRUE));
            }
        });
    }

    private void getUser(String username, Handler<AsyncResult<User>> handler) {
        if (this.users == null) {
            this.readFile((Handler<AsyncResult<Boolean>>)((Handler)readFileResponse -> {
                User result = this.users.get(username);
                handler.handle((Object)(result != null ? Future.succeededFuture((Object)result) : Future.failedFuture((String)"unknown user")));
            }));
        } else {
            User result = this.users.get(username);
            handler.handle((Object)(result != null ? Future.succeededFuture((Object)result) : Future.failedFuture((String)"unknown user")));
        }
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<io.vertx.ext.auth.User>> resultHandler) {
        String username = authInfo.getString("username");
        String password = authInfo.getString("password");
        this.getUser(username, (Handler<AsyncResult<User>>)((Handler)userResult -> {
            if (userResult.succeeded()) {
                User propertyUser = (User)userResult.result();
                if (Objects.equals(propertyUser.password, password)) {
                    UserImpl result = new UserImpl(new JsonObject().put("username", (Object)propertyUser.name));
                    this.getAuthorizations((io.vertx.ext.auth.User)result, (Handler<AsyncResult<Set<Authorization>>>)((Handler)arg_0 -> this.lambda$null$7(resultHandler, (io.vertx.ext.auth.User)result, arg_0)));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((String)"invalid username/password"));
                }
            } else {
                resultHandler.handle((Object)Future.failedFuture((String)"invalid username/password"));
            }
        }));
    }

    public String getId() {
        return this.path;
    }

    public void getAuthorizations(io.vertx.ext.auth.User user, Handler<AsyncResult<Set<Authorization>>> resultHandler) {
        String username = user.principal().getString("username");
        this.getUser(username, (Handler<AsyncResult<User>>)((Handler)userResult -> {
            if (userResult.succeeded()) {
                HashSet<Object> result = new HashSet<Object>();
                for (Role role : ((User)userResult.result()).roles.values()) {
                    result.add(RoleBasedAuthorization.create((String)role.name));
                    for (String permission : role.permissions) {
                        result.add(WildcardPermissionBasedAuthorization.create((String)permission));
                    }
                }
                resultHandler.handle((Object)Future.succeededFuture(result));
            } else {
                resultHandler.handle((Object)Future.failedFuture((String)"invalid username"));
            }
        }));
    }

    private /* synthetic */ void lambda$null$7(Handler resultHandler, io.vertx.ext.auth.User result, AsyncResult authorizationsResult) {
        if (authorizationsResult.failed()) {
            resultHandler.handle((Object)Future.failedFuture((String)"invalid username/password"));
        } else {
            result.authorizations().add(this.getId(), (Set)authorizationsResult.result());
            resultHandler.handle((Object)Future.succeededFuture((Object)result));
        }
    }

    private static class Role {
        String name;
        Set<String> permissions;

        private Role(String name) {
            this.name = Objects.requireNonNull(name);
            this.permissions = new HashSet<String>();
        }

        private void addPermission(String permission) {
            Objects.requireNonNull(permission);
            this.permissions.add(permission);
        }
    }

    private static class User {
        String name;
        String password;
        Map<String, Role> roles;

        private User(String name) {
            this.name = Objects.requireNonNull(name);
            this.roles = new HashMap<String, Role>();
        }

        private void addRole(Role role) {
            Objects.requireNonNull(role);
            this.roles.put(role.name, role);
        }
    }
}

