/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.otp.hotp.impl;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.otp.Authenticator;
import io.vertx.ext.auth.otp.OtpCredentials;
import io.vertx.ext.auth.otp.OtpKey;
import io.vertx.ext.auth.otp.hotp.HotpAuth;
import io.vertx.ext.auth.otp.hotp.HotpAuthOptions;
import io.vertx.ext.auth.otp.impl.org.openauthentication.otp.OneTimePasswordAlgorithm;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.function.Function;

public class HotpAuthImpl
implements HotpAuth {
    private final HotpAuthOptions hotpAuthOptions;
    private Function<String, Future<Authenticator>> fetcher;
    private Function<Authenticator, Future<Void>> updater;

    public HotpAuthImpl(HotpAuthOptions hotpAuthOptions) {
        if (hotpAuthOptions == null) {
            throw new IllegalArgumentException("hotpAuthOptions cannot null");
        }
        this.hotpAuthOptions = hotpAuthOptions;
    }

    public Future<User> authenticate(Credentials credentials) {
        OtpCredentials authInfo;
        try {
            try {
                authInfo = (OtpCredentials)credentials;
            }
            catch (ClassCastException e) {
                throw new CredentialValidationException("Invalid credentials type", (Throwable)e);
            }
            authInfo.checkValid(this.hotpAuthOptions);
        }
        catch (RuntimeException e) {
            return Future.failedFuture((Throwable)e);
        }
        return this.fetcher.apply(authInfo.getIdentifier()).compose(authenticator -> {
            String oneTimePassword;
            int n;
            if (authenticator == null) {
                return Future.failedFuture((String)"user is not found");
            }
            long counter = authenticator.getCounter();
            String key = authenticator.getKey();
            String algorithm = authenticator.getAlgorithm();
            OtpKey otpKey = new OtpKey().setKey(key).setAlgorithm(algorithm);
            ++counter;
            Integer authAttempts = authenticator.getAuthAttempts();
            if (authAttempts != null) {
                authAttempts = authAttempts + 1;
                n = authAttempts;
            } else {
                n = 1;
            }
            authAttempts = n;
            authenticator.setAuthAttempts(authAttempts);
            try {
                oneTimePassword = OneTimePasswordAlgorithm.generateOTP(otpKey.getKeyBytes(), counter, this.hotpAuthOptions.getPasswordLength(), false, -1);
            }
            catch (GeneralSecurityException e) {
                return Future.failedFuture((Throwable)e);
            }
            if (oneTimePassword.equals(authInfo.getCode())) {
                authenticator.setCounter(counter);
                return this.updater.apply((Authenticator)authenticator).compose(v -> Future.succeededFuture((Object)this.createUser((Authenticator)authenticator)));
            }
            if (this.hotpAuthOptions.isUsingAttemptsLimit() && authAttempts >= this.hotpAuthOptions.getAuthAttemptsLimit()) {
                return this.updater.apply((Authenticator)authenticator).compose(v -> Future.failedFuture((String)"invalid code"));
            }
            if (this.hotpAuthOptions.isUsingResynchronization()) {
                for (int i = 0; i < this.hotpAuthOptions.getLookAheadWindow(); ++i) {
                    ++counter;
                    try {
                        oneTimePassword = OneTimePasswordAlgorithm.generateOTP(otpKey.getKeyBytes(), counter, this.hotpAuthOptions.getPasswordLength(), false, -1);
                    }
                    catch (GeneralSecurityException e) {
                        return Future.failedFuture((Throwable)e);
                    }
                    if (!MessageDigest.isEqual(oneTimePassword.getBytes(StandardCharsets.UTF_8), authInfo.getCode().getBytes(StandardCharsets.UTF_8))) continue;
                    authenticator.setCounter(counter);
                    return this.updater.apply((Authenticator)authenticator).compose(v -> Future.succeededFuture((Object)this.createUser((Authenticator)authenticator)));
                }
            }
            return Future.failedFuture((String)"invalid code");
        });
    }

    @Override
    public HotpAuth authenticatorFetcher(Function<String, Future<Authenticator>> fetcher) {
        this.fetcher = fetcher;
        return this;
    }

    @Override
    public HotpAuth authenticatorUpdater(Function<Authenticator, Future<Void>> updater) {
        this.updater = updater;
        return this;
    }

    @Override
    public Future<Authenticator> createAuthenticator(String id, OtpKey otpKey) {
        Authenticator authenticator = new Authenticator(true).setIdentifier(id).setKey(otpKey.getKey()).setAlgorithm(otpKey.getAlgorithm()).setCounter(this.hotpAuthOptions.getCounter());
        return this.updater.apply(authenticator).map((Object)authenticator);
    }

    @Override
    public String generateUri(OtpKey otpKey, String issuer, String user, String label) {
        try {
            if (label == null) {
                if (issuer == null) {
                    throw new IllegalArgumentException("label and issuer cannot all be null");
                }
                label = user == null ? URLEncoder.encode(issuer, "UTF8") : URLEncoder.encode(issuer, "UTF8") + ":" + URLEncoder.encode(user, "UTF8");
            }
            StringBuilder sb = new StringBuilder();
            sb.append("secret=").append(otpKey.getKey());
            if (issuer != null) {
                sb.append("&issuer=").append(URLEncoder.encode(issuer, "UTF8"));
            }
            if (otpKey.getAlgorithm() != null && !otpKey.getAlgorithm().equals("SHA1")) {
                sb.append("&algorithm=").append(otpKey.getAlgorithm());
            }
            if (this.hotpAuthOptions.getPasswordLength() != 6) {
                sb.append("&digits=").append(this.hotpAuthOptions.getPasswordLength());
            }
            sb.append("&counter=").append(this.hotpAuthOptions.getCounter());
            return String.format("otpauth://hotp/%s?%s", label, sb);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private User createUser(Authenticator authenticator) {
        return User.create((JsonObject)new JsonObject().put("otp", (Object)"hotp").put("counter", (Object)authenticator.getCounter()).put("auth_attempts", (Object)authenticator.getAuthAttempts()).put("amr", Arrays.asList("mfa", "otp")));
    }
}

