/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.otp.hotp;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.otp.Authenticator;
import io.vertx.ext.auth.otp.OtpKey;
import io.vertx.ext.auth.otp.hotp.HotpAuthOptions;
import io.vertx.ext.auth.otp.hotp.impl.HotpAuthImpl;
import java.util.function.Function;

@VertxGen
public interface HotpAuth
extends AuthenticationProvider {
    @Fluent
    public HotpAuth authenticatorFetcher(Function<String, Future<Authenticator>> var1);

    @Fluent
    public HotpAuth authenticatorUpdater(Function<Authenticator, Future<Void>> var1);

    public Future<Authenticator> createAuthenticator(String var1, OtpKey var2);

    public String generateUri(OtpKey var1, String var2, String var3, String var4);

    default public String generateUri(OtpKey otpKey, String issuer, String user) {
        return this.generateUri(otpKey, issuer, user, null);
    }

    default public String generateUri(OtpKey otpKey, String label) {
        return this.generateUri(otpKey, null, null, label);
    }

    public static HotpAuth create() {
        return HotpAuth.create(new HotpAuthOptions());
    }

    public static HotpAuth create(HotpAuthOptions hotpAuthOptions) {
        return new HotpAuthImpl(hotpAuthOptions);
    }
}

