/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.otp;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.otp.OtpCredentialsConverter;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class OtpCredentials
implements Credentials {
    private String identifier;
    private String code;

    public OtpCredentials(JsonObject jsonObject) {
        OtpCredentialsConverter.fromJson((Iterable<Map.Entry<String, Object>>)jsonObject, this);
    }

    public OtpCredentials(String identifier, String code) {
        this.identifier = identifier;
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public OtpCredentials setCode(String code) {
        this.code = code;
        return this;
    }

    public OtpCredentials setIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public <V> void checkValid(V arg) throws CredentialValidationException {
        if (this.identifier == null || this.identifier.length() == 0) {
            throw new CredentialValidationException("identifier cannot null or empty");
        }
        if (this.code == null || this.code.length() == 0) {
            throw new CredentialValidationException("code cannot null or empty");
        }
    }

    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        OtpCredentialsConverter.toJson(this, result);
        return result;
    }
}

