/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.otp.totp;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.otp.totp.TotpAuthOptionsConverter;
import java.util.Map;

@DataObject(generateConverter=true)
public class TotpAuthOptions {
    private int passwordLength = 6;
    private int authAttemptsLimit;
    private long period = 30L;

    public TotpAuthOptions(JsonObject jsonObject) {
        TotpAuthOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)jsonObject, this);
    }

    public TotpAuthOptions() {
    }

    public TotpAuthOptions(int passwordLength, int authAttemptsLimit, long period) {
        this.setPasswordLength(passwordLength);
        this.setAuthAttemptsLimit(authAttemptsLimit);
        this.setPeriod(period);
    }

    public int getPasswordLength() {
        return this.passwordLength;
    }

    public int getAuthAttemptsLimit() {
        return this.authAttemptsLimit;
    }

    public long getPeriod() {
        return this.period;
    }

    public TotpAuthOptions setPasswordLength(int passwordLength) {
        if (passwordLength < 6 || passwordLength > 8) {
            throw new IllegalArgumentException("password length must be between 6 and 8 digits");
        }
        this.passwordLength = passwordLength;
        return this;
    }

    public TotpAuthOptions setAuthAttemptsLimit(int authAttemptsLimit) {
        if (authAttemptsLimit < 0) {
            throw new IllegalArgumentException("Auth attempts limit must above 0");
        }
        this.authAttemptsLimit = authAttemptsLimit;
        return this;
    }

    public TotpAuthOptions setPeriod(long period) {
        if (period < 0L) {
            throw new IllegalArgumentException("Period must above 0");
        }
        this.period = period;
        return this;
    }

    @GenIgnore
    public boolean isUsingAttemptsLimit() {
        return this.authAttemptsLimit > 0;
    }
}

