/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.otp.totp.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.otp.Authenticator;
import io.vertx.ext.auth.otp.OtpKey;
import io.vertx.ext.auth.otp.impl.org.openauthentication.otp.OneTimePasswordAlgorithm;
import io.vertx.ext.auth.otp.totp.TotpAuth;
import io.vertx.ext.auth.otp.totp.TotpAuthOptions;
import io.vertx.ext.auth.otp.totp.TotpCredentials;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.util.function.Function;

public class TotpAuthImpl
implements TotpAuth {
    private final TotpAuthOptions totpAuthOptions;
    private Function<String, Future<Authenticator>> fetcher;
    private Function<Authenticator, Future<Void>> updater;

    public TotpAuthImpl(TotpAuthOptions totpAuthOptions) {
        if (totpAuthOptions == null) {
            throw new IllegalArgumentException("totpAuthOptions cannot null");
        }
        this.totpAuthOptions = totpAuthOptions;
    }

    public void authenticate(JsonObject credentials, Handler<AsyncResult<User>> resultHandler) {
        this.authenticate(new TotpCredentials(credentials), resultHandler);
    }

    public void authenticate(Credentials credentials, Handler<AsyncResult<User>> resultHandler) {
        try {
            TotpCredentials authInfo = (TotpCredentials)credentials;
            authInfo.checkValid(this.totpAuthOptions);
            this.fetcher.apply(authInfo.getIdentifier()).onFailure(err -> resultHandler.handle((Object)Future.failedFuture((Throwable)err))).onSuccess(authenticator -> {
                if (authenticator == null) {
                    resultHandler.handle((Object)Future.failedFuture((String)"user is not found"));
                } else {
                    String oneTimePassword;
                    int n;
                    String key = authenticator.getKey();
                    String algorithm = authenticator.getAlgorithm();
                    OtpKey otpKey = new OtpKey().setKey(key).setAlgorithm(algorithm);
                    Integer authAttempts = authenticator.getAuthAttempts();
                    if (authAttempts != null) {
                        authAttempts = authAttempts + 1;
                        n = authAttempts;
                    } else {
                        n = 1;
                    }
                    authAttempts = n;
                    authenticator.setAuthAttempts(authAttempts);
                    try {
                        long movingFactor = Instant.now().getEpochSecond() / this.totpAuthOptions.getPeriod();
                        oneTimePassword = OneTimePasswordAlgorithm.generateOTP(otpKey.getKeyBytes(), movingFactor, this.totpAuthOptions.getPasswordLength(), false, -1);
                    }
                    catch (GeneralSecurityException e) {
                        resultHandler.handle((Object)Future.failedFuture((Throwable)e));
                        return;
                    }
                    if (oneTimePassword.equals(authInfo.getCode())) {
                        this.updater.apply((Authenticator)authenticator).onFailure(err -> resultHandler.handle((Object)Future.failedFuture((Throwable)err))).onSuccess(v -> resultHandler.handle((Object)Future.succeededFuture((Object)this.createUser((Authenticator)authenticator))));
                        return;
                    }
                    if (this.totpAuthOptions.isUsingAttemptsLimit() && authAttempts >= this.totpAuthOptions.getAuthAttemptsLimit()) {
                        this.updater.apply((Authenticator)authenticator).onFailure(err -> resultHandler.handle((Object)Future.failedFuture((Throwable)err))).onSuccess(v -> resultHandler.handle((Object)Future.failedFuture((String)"invalid code")));
                        return;
                    }
                    resultHandler.handle((Object)Future.failedFuture((String)"invalid code"));
                }
            });
        }
        catch (RuntimeException e) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    @Override
    public TotpAuth authenticatorFetcher(Function<String, Future<Authenticator>> fetcher) {
        this.fetcher = fetcher;
        return this;
    }

    @Override
    public TotpAuth authenticatorUpdater(Function<Authenticator, Future<Void>> updater) {
        this.updater = updater;
        return this;
    }

    @Override
    public Future<Authenticator> createAuthenticator(String id, OtpKey otpKey) {
        Authenticator authenticator = new Authenticator(true).setIdentifier(id).setKey(otpKey.getKey()).setAlgorithm(otpKey.getAlgorithm()).setCounter(0L);
        return this.updater.apply(authenticator).map((Object)authenticator);
    }

    @Override
    public String generateUri(OtpKey otpKey, long period, String issuer, String user, String label) {
        try {
            if (label == null) {
                if (issuer == null) {
                    throw new IllegalArgumentException("label and issuer cannot all be null");
                }
                label = user == null ? URLEncoder.encode(issuer, "UTF8") : URLEncoder.encode(issuer, "UTF8") + ":" + URLEncoder.encode(user, "UTF8");
            }
            StringBuilder sb = new StringBuilder();
            sb.append("secret=").append(otpKey.getKey());
            if (issuer != null) {
                sb.append("&issuer=").append(URLEncoder.encode(issuer, "UTF8"));
            }
            if (otpKey.getAlgorithm() != null && !otpKey.getAlgorithm().equals("SHA1")) {
                sb.append("&algorithm=").append(otpKey.getAlgorithm());
            }
            if (this.totpAuthOptions.getPasswordLength() != 6) {
                sb.append("&digits=").append(this.totpAuthOptions.getPasswordLength());
            }
            sb.append("&period=").append(period);
            return String.format("otpauth://totp/%s?%s", label, sb);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private User createUser(Authenticator authenticator) {
        return User.create((JsonObject)new JsonObject().put("otp", (Object)"totp").put("auth_attempts", (Object)authenticator.getAuthAttempts()));
    }

    public TotpAuthOptions getTotpAuthOptions() {
        return this.totpAuthOptions;
    }
}

