/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.otp.hotp;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.otp.hotp.HotpAuthOptionsConverter;
import java.util.Map;

@DataObject(generateConverter=true)
public class HotpAuthOptions {
    private int passwordLength = 6;
    private int authAttemptsLimit;
    private int lookAheadWindow;

    public HotpAuthOptions(JsonObject jsonObject) {
        HotpAuthOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)jsonObject, this);
    }

    public HotpAuthOptions() {
    }

    public HotpAuthOptions(int passwordLength, int authAttemptsLimit, int lookAheadWindow) {
        this.setPasswordLength(passwordLength);
        this.setAuthAttemptsLimit(authAttemptsLimit);
        this.setLookAheadWindow(lookAheadWindow);
    }

    public int getPasswordLength() {
        return this.passwordLength;
    }

    public int getAuthAttemptsLimit() {
        return this.authAttemptsLimit;
    }

    public int getLookAheadWindow() {
        return this.lookAheadWindow;
    }

    public HotpAuthOptions setPasswordLength(int passwordLength) {
        if (passwordLength < 6 || passwordLength > 8) {
            throw new IllegalArgumentException("password length must be between 6 and 8 digits");
        }
        this.passwordLength = passwordLength;
        return this;
    }

    public HotpAuthOptions setAuthAttemptsLimit(int authAttemptsLimit) {
        if (authAttemptsLimit < 0) {
            throw new IllegalArgumentException("Auth attempts limit must above 0");
        }
        this.authAttemptsLimit = authAttemptsLimit;
        return this;
    }

    public HotpAuthOptions setLookAheadWindow(int lookAheadWindow) {
        if (lookAheadWindow < 0) {
            throw new IllegalArgumentException("look ahead window must above 0");
        }
        this.lookAheadWindow = lookAheadWindow;
        return this;
    }

    @GenIgnore
    public boolean isUsingAttemptsLimit() {
        return this.authAttemptsLimit > 0;
    }

    @GenIgnore
    public boolean isUsingResynchronization() {
        return this.lookAheadWindow > 0;
    }
}

